/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.test.repository.RepositorySupport;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.metadata.resolver.impl.FileBackedHTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.impl.SecurityEnhancedHttpClientSupport;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.trust.impl.ExplicitKeyTrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.PKIXTrustEvaluator;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.security.x509.impl.BasicPKIXValidationInformation;
import org.opensaml.security.x509.impl.BasicX509CredentialNameEvaluator;
import org.opensaml.security.x509.impl.CertPathPKIXTrustEvaluator;
import org.opensaml.security.x509.impl.PKIXX509CredentialTrustEngine;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.opensaml.security.x509.impl.X509CredentialNameEvaluator;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HTTPMetadataResolverTest
extends XMLObjectBaseTestCase {
    private HttpClientBuilder httpClientBuilder;
    private String metadataURLHttp;
    private String metadataURLHttps;
    private String badMDURL;
    private String entityID;
    private HTTPMetadataResolver metadataProvider;
    private CriteriaSet criteriaSet;
    static final String DATA_PATH = "/org/opensaml/saml/metadata/resolver/impl/";

    @BeforeClass
    protected void setUpClass() {
        this.metadataURLHttps = RepositorySupport.buildHTTPSResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/08ced64cddc9f1578598b2cf71ae747b11d11472.xml");
        this.metadataURLHttp = RepositorySupport.buildHTTPResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/08ced64cddc9f1578598b2cf71ae747b11d11472.xml", (boolean)false);
    }

    @BeforeMethod
    protected void setUpMethod() throws Exception {
        this.httpClientBuilder = new HttpClientBuilder();
        this.badMDURL = "http://www.google.com/";
        this.entityID = "https://www.example.org/sp";
        this.criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID)});
    }

    @Test
    public void testGetEntityDescriptor() throws Exception {
        try {
            this.metadataProvider = new HTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttp);
            this.metadataProvider.setParserPool(parserPool);
            this.metadataProvider.setId("test");
            this.metadataProvider.initialize();
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertTrue((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNull((Object)this.metadataProvider.getLastFailureCause());
        }
        catch (ComponentInitializationException e) {
            Assert.fail((String)"Valid metadata failed init");
        }
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testFailFastBadURL() throws Exception {
        this.metadataProvider = new HTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.badMDURL);
        this.metadataProvider.setFailFastInitialization(true);
        this.metadataProvider.setId("test");
        this.metadataProvider.setParserPool(parserPool);
        try {
            this.metadataProvider.initialize();
            Assert.fail((String)"metadata provider claims to have parsed known invalid data");
        }
        catch (ComponentInitializationException e) {
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertFalse((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNotNull((Object)this.metadataProvider.getLastFailureCause());
            Assert.assertTrue((boolean)ResolverException.class.isInstance(this.metadataProvider.getLastFailureCause()));
        }
    }

    @Test
    public void testNoFailFastBadURL() throws Exception {
        this.metadataProvider = new HTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.badMDURL);
        this.metadataProvider.setFailFastInitialization(false);
        this.metadataProvider.setId("test");
        this.metadataProvider.setParserPool(parserPool);
        try {
            this.metadataProvider.initialize();
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertFalse((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNotNull((Object)this.metadataProvider.getLastFailureCause());
            Assert.assertTrue((boolean)ResolverException.class.isInstance(this.metadataProvider.getLastFailureCause()));
        }
        catch (ComponentInitializationException e) {
            Assert.fail((String)"Provider failed init with fail-fast=false");
        }
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)descriptor);
    }

    @Test
    public void testTrustEngineSocketFactoryNoHTTPSNoTrustEngine() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory(true));
        this.metadataProvider = new HTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttp);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
        Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
        Assert.assertTrue((boolean)this.metadataProvider.wasLastRefreshSuccess());
        Assert.assertNull((Object)this.metadataProvider.getLastFailureCause());
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testTrustEngineSocketFactoryNoHTTPSWithTrustEngine() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.metadataProvider = new HTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("repo-entity.crt"));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        this.metadataProvider.initialize();
        Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
        Assert.assertTrue((boolean)this.metadataProvider.wasLastRefreshSuccess());
        Assert.assertNull((Object)this.metadataProvider.getLastFailureCause());
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testHTTPSNoTrustEngine() throws Exception {
        try {
            System.setProperty("javax.net.ssl.trustStore", ((Object)((Object)this)).getClass().getResource("repo.truststore.jks").getFile());
            System.setProperty("javax.net.ssl.trustStorePassword", "shibboleth");
            this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory(false));
            this.metadataProvider = new HTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps);
            this.metadataProvider.setParserPool(parserPool);
            this.metadataProvider.setId("test");
            this.metadataProvider.initialize();
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertTrue((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNull((Object)this.metadataProvider.getLastFailureCause());
            EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
            Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
            Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
        }
        finally {
            System.setProperty("javax.net.ssl.trustStore", "");
            System.setProperty("javax.net.ssl.trustStorePassword", "");
        }
    }

    @Test
    public void testHTTPSTrustEngineExplicitKey() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.metadataProvider = new HTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("repo-entity.crt"));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        this.metadataProvider.initialize();
        Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
        Assert.assertTrue((boolean)this.metadataProvider.wasLastRefreshSuccess());
        Assert.assertNull((Object)this.metadataProvider.getLastFailureCause());
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testHTTPSTrustEngineInvalidKey() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.metadataProvider = new HTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("badKey.crt"));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        try {
            this.metadataProvider.initialize();
            Assert.fail((String)"Invalid metadata TLS should have failed init");
        }
        catch (ComponentInitializationException e) {
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertFalse((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNotNull((Object)this.metadataProvider.getLastFailureCause());
            Assert.assertTrue((boolean)ResolverException.class.isInstance(this.metadataProvider.getLastFailureCause()));
        }
    }

    @Test
    public void testHTTPSTrustEngineValidPKIX() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.metadataProvider = new HTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildPKIXTrustEngine("repo-rootCA.crt", null, false));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        this.metadataProvider.initialize();
        Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
        Assert.assertTrue((boolean)this.metadataProvider.wasLastRefreshSuccess());
        Assert.assertNull((Object)this.metadataProvider.getLastFailureCause());
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testHTTPSTrustEngineValidPKIXExplicitName() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.metadataProvider = new HTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildPKIXTrustEngine("repo-rootCA.crt", "test.shibboleth.net", true));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        this.metadataProvider.initialize();
        Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
        Assert.assertTrue((boolean)this.metadataProvider.wasLastRefreshSuccess());
        Assert.assertNull((Object)this.metadataProvider.getLastFailureCause());
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testHTTPSTrustEngineInvalidPKIX() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.metadataProvider = new HTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildPKIXTrustEngine("badCA.crt", null, false));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        try {
            this.metadataProvider.initialize();
            Assert.fail((String)"Invalid metadata TLS should have failed init");
        }
        catch (ComponentInitializationException e) {
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertFalse((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNotNull((Object)this.metadataProvider.getLastFailureCause());
            Assert.assertTrue((boolean)ResolverException.class.isInstance(this.metadataProvider.getLastFailureCause()));
        }
    }

    @Test
    public void testHTTPSTrustEngineValidPKIXInvalidName() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.metadataProvider = new HTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildPKIXTrustEngine("repo-rootCA.crt", "foobar.shibboleth.net", true));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        try {
            this.metadataProvider.initialize();
            Assert.fail((String)"Invalid metadata TLS should have failed init");
        }
        catch (ComponentInitializationException e) {
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertFalse((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNotNull((Object)this.metadataProvider.getLastFailureCause());
            Assert.assertTrue((boolean)ResolverException.class.isInstance(this.metadataProvider.getLastFailureCause()));
        }
    }

    @Test
    public void testHTTPSTrustEngineWrongSocketFactory() throws Exception {
        this.metadataProvider = new HTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("repo-entity.crt"));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        try {
            this.metadataProvider.initialize();
            Assert.fail((String)"Invalid metadata TLS should have failed init");
        }
        catch (ComponentInitializationException e) {
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertFalse((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNotNull((Object)this.metadataProvider.getLastFailureCause());
            Assert.assertTrue((boolean)ResolverException.class.isInstance(this.metadataProvider.getLastFailureCause()));
        }
    }

    public static TrustEngine<? super X509Credential> buildPKIXTrustEngine(String cert, String name, boolean nameCheckEnabled) throws URISyntaxException, CertificateException, IOException {
        InputStream certStream = FileBackedHTTPMetadataResolver.class.getResourceAsStream(DATA_PATH + cert);
        X509Certificate rootCert = X509Support.decodeCertificate((byte[])ByteStreams.toByteArray((InputStream)certStream));
        BasicPKIXValidationInformation info = new BasicPKIXValidationInformation(Collections.singletonList(rootCert), null, Integer.valueOf(5));
        Set<Object> trustedNames = name != null ? Collections.singleton(name) : Collections.emptySet();
        StaticPKIXValidationInformationResolver resolver = new StaticPKIXValidationInformationResolver(Collections.singletonList(info), trustedNames);
        return new PKIXX509CredentialTrustEngine((PKIXValidationInformationResolver)resolver, (PKIXTrustEvaluator)new CertPathPKIXTrustEvaluator(), (X509CredentialNameEvaluator)(nameCheckEnabled ? new BasicX509CredentialNameEvaluator() : null));
    }

    public static TrustEngine<? super X509Credential> buildExplicitKeyTrustEngine(String cert) throws URISyntaxException, CertificateException, IOException {
        InputStream certStream = FileBackedHTTPMetadataResolver.class.getResourceAsStream(DATA_PATH + cert);
        X509Certificate entityCert = X509Support.decodeCertificate((byte[])ByteStreams.toByteArray((InputStream)certStream));
        BasicX509Credential entityCredential = new BasicX509Credential(entityCert);
        return new ExplicitKeyTrustEngine((CredentialResolver)new StaticCredentialResolver((Credential)entityCredential));
    }

    public static LayeredConnectionSocketFactory buildSocketFactory() {
        return HTTPMetadataResolverTest.buildSocketFactory(true);
    }

    public static LayeredConnectionSocketFactory buildSocketFactory(boolean supportTrustEngine) {
        return SecurityEnhancedHttpClientSupport.buildTLSSocketFactory((boolean)supportTrustEngine, (boolean)false);
    }
}

