/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.collect.Lists;
import java.util.List;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.impl.MetadataQueryProtocolRequestURLBuilder;
import org.opensaml.saml.metadata.resolver.index.impl.SimpleStringCriterion;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetadataQueryProtocolRequestURLBuilderTest {
    private MetadataQueryProtocolRequestURLBuilder function;

    @Test
    public void testWithoutTrailingSlash() {
        this.function = new MetadataQueryProtocolRequestURLBuilder("http://metadata.example.org/service");
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://example.org/idp")})), (String)"http://metadata.example.org/service/entities/http:%2F%2Fexample.org%2Fidp");
    }

    @Test
    public void testWithTrailingSlash() {
        this.function = new MetadataQueryProtocolRequestURLBuilder("http://metadata.example.org/service/");
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://example.org/idp")})), (String)"http://metadata.example.org/service/entities/http:%2F%2Fexample.org%2Fidp");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullCriteria() {
        this.function = new MetadataQueryProtocolRequestURLBuilder("http://metadata.example.org/service/");
        this.function.apply(null);
    }

    @Test
    public void testSecondaryURLBuilders() {
        MockURLBuilder foo = new MockURLBuilder("tags/foo");
        MockURLBuilder bar = new MockURLBuilder("tags/bar");
        MockURLBuilder noValue = new MockURLBuilder(null);
        this.function = new MetadataQueryProtocolRequestURLBuilder("http://metadata.example.org/service", (List)Lists.newArrayList((Object[])new MetadataQueryProtocolRequestURLBuilder.MetadataQueryProtocolURLBuilder[]{foo, bar}));
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new SimpleStringCriterion("will-be-ignored")})), (String)"http://metadata.example.org/service/tags/foo");
        this.function = new MetadataQueryProtocolRequestURLBuilder("http://metadata.example.org/service", (List)Lists.newArrayList((Object[])new MetadataQueryProtocolRequestURLBuilder.MetadataQueryProtocolURLBuilder[]{bar, foo}));
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new SimpleStringCriterion("will-be-ignored")})), (String)"http://metadata.example.org/service/tags/bar");
        this.function = new MetadataQueryProtocolRequestURLBuilder("http://metadata.example.org/service", (List)Lists.newArrayList((Object[])new MetadataQueryProtocolRequestURLBuilder.MetadataQueryProtocolURLBuilder[]{noValue, foo, bar}));
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new SimpleStringCriterion("will-be-ignored")})), (String)"http://metadata.example.org/service/tags/foo");
    }

    public static class MockURLBuilder
    implements MetadataQueryProtocolRequestURLBuilder.MetadataQueryProtocolURLBuilder {
        private String suffix;

        public MockURLBuilder(String s) {
            this.suffix = s;
        }

        public String buildURL(String baseURL, CriteriaSet criteria) {
            if (this.suffix == null) {
                return null;
            }
            return baseURL + this.suffix;
        }
    }
}

