/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.io.File;
import java.net.URL;
import java.time.Duration;
import java.util.Timer;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.resource.Resource;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.metadata.resolver.impl.ResourceBackedMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.core.io.FileSystemResource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ResourceBackedMetadataResolverTest
extends XMLObjectBaseTestCase {
    private ResourceBackedMetadataResolver metadataProvider;
    private String entityID;
    private CriteriaSet criteriaSet;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.entityID = "urn:mace:incommon:washington.edu";
        URL mdURL = ResourceBackedMetadataResolverTest.class.getResource("/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml");
        Resource mdResource = ResourceHelper.of((org.springframework.core.io.Resource)new FileSystemResource(new File(mdURL.toURI()).getAbsolutePath()));
        this.metadataProvider = new ResourceBackedMetadataResolver(new Timer(true), mdResource);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setMaxRefreshDelay(Duration.ofSeconds(500L));
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
        this.criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID)});
    }

    @Test
    public void testGetEntityDescriptor() throws ResolverException {
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }
}

