/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.index.impl;

import java.util.Set;
import javax.xml.namespace.QName;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.metadata.resolver.index.MetadataIndexKey;
import org.opensaml.saml.metadata.resolver.index.SimpleStringMetadataIndexKey;
import org.opensaml.saml.metadata.resolver.index.impl.MetadataIndexStore;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MetadataIndexStoreTest
extends OpenSAMLInitBaseTestCase {
    private MetadataIndexStore<EntityDescriptor> store;
    private MetadataIndexKey key1;
    private MetadataIndexKey key2;
    private EntityDescriptor a;
    private EntityDescriptor b;
    private EntityDescriptor c;
    private Set<EntityDescriptor> result;

    @BeforeMethod
    protected void setUp() {
        this.store = new MetadataIndexStore();
        this.key1 = new SimpleStringMetadataIndexKey("foo");
        this.key2 = new SimpleStringMetadataIndexKey("bar");
        this.a = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.b = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.c = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.result = null;
    }

    @Test
    public void testAddRemoveLookup() {
        Assert.assertTrue((boolean)this.store.lookup(this.key1).isEmpty());
        Assert.assertTrue((boolean)this.store.lookup(this.key2).isEmpty());
        this.store.add(this.key1, (Object)this.a);
        this.result = this.store.lookup(this.key1);
        Assert.assertEquals((int)this.result.size(), (int)1);
        Assert.assertTrue((boolean)this.result.contains(this.a));
        this.store.add(this.key1, (Object)this.b);
        this.store.add(this.key1, (Object)this.c);
        this.result = this.store.lookup(this.key1);
        Assert.assertEquals((int)this.result.size(), (int)3);
        Assert.assertTrue((boolean)this.result.contains(this.a));
        Assert.assertTrue((boolean)this.result.contains(this.b));
        Assert.assertTrue((boolean)this.result.contains(this.c));
        this.store.add(this.key1, (Object)this.a);
        this.result = this.store.lookup(this.key1);
        Assert.assertEquals((int)this.result.size(), (int)3);
        Assert.assertTrue((boolean)this.result.contains(this.a));
        Assert.assertTrue((boolean)this.result.contains(this.b));
        Assert.assertTrue((boolean)this.result.contains(this.c));
        this.store.remove(this.key1, (Object)this.b);
        this.result = this.store.lookup(this.key1);
        Assert.assertEquals((int)this.result.size(), (int)2);
        Assert.assertTrue((boolean)this.result.contains(this.a));
        Assert.assertTrue((boolean)this.result.contains(this.c));
        this.store.remove(this.key1, (Object)this.b);
        this.result = this.store.lookup(this.key1);
        Assert.assertEquals((int)this.result.size(), (int)2);
        Assert.assertTrue((boolean)this.result.contains(this.a));
        Assert.assertTrue((boolean)this.result.contains(this.c));
        this.store.add(this.key2, (Object)this.b);
        this.result = this.store.lookup(this.key1);
        Assert.assertEquals((int)this.result.size(), (int)2);
        Assert.assertTrue((boolean)this.result.contains(this.a));
        Assert.assertTrue((boolean)this.result.contains(this.c));
        this.result = this.store.lookup(this.key2);
        Assert.assertEquals((int)this.result.size(), (int)1);
        Assert.assertTrue((boolean)this.result.contains(this.b));
        this.store.remove(this.key1, (Object)this.a);
        this.store.remove(this.key1, (Object)this.c);
        this.store.remove(this.key2, (Object)this.b);
        Assert.assertTrue((boolean)this.store.lookup(this.key1).isEmpty());
        Assert.assertTrue((boolean)this.store.lookup(this.key2).isEmpty());
    }

    @Test
    public void testGetKeys() {
        Set keys = null;
        Assert.assertTrue((boolean)this.store.getKeys().isEmpty());
        this.store.add(this.key1, (Object)this.a);
        keys = this.store.getKeys();
        Assert.assertFalse((boolean)keys.isEmpty());
        Assert.assertEquals((int)keys.size(), (int)1);
        this.store.add(this.key1, (Object)this.b);
        this.store.add(this.key2, (Object)this.c);
        keys = this.store.getKeys();
        Assert.assertFalse((boolean)keys.isEmpty());
        Assert.assertEquals((int)keys.size(), (int)2);
        this.store.clear(this.key1);
        this.store.clear(this.key2);
        Assert.assertTrue((boolean)this.store.getKeys().isEmpty());
    }

    @Test
    public void testClearIndex() {
        Assert.assertTrue((boolean)this.store.lookup(this.key1).isEmpty());
        this.store.add(this.key1, (Object)this.a);
        this.store.add(this.key1, (Object)this.b);
        this.store.add(this.key1, (Object)this.c);
        Assert.assertFalse((boolean)this.store.lookup(this.key1).isEmpty());
        Assert.assertEquals((int)this.store.lookup(this.key1).size(), (int)3);
        this.store.clear(this.key1);
        Assert.assertTrue((boolean)this.store.lookup(this.key1).isEmpty());
    }

    @Test
    public void testClearAll() {
        Assert.assertTrue((boolean)this.store.lookup(this.key1).isEmpty());
        Assert.assertTrue((boolean)this.store.lookup(this.key2).isEmpty());
        this.store.add(this.key1, (Object)this.a);
        this.store.add(this.key2, (Object)this.b);
        Assert.assertFalse((boolean)this.store.lookup(this.key1).isEmpty());
        Assert.assertFalse((boolean)this.store.lookup(this.key2).isEmpty());
        this.store.clear();
        Assert.assertTrue((boolean)this.store.lookup(this.key1).isEmpty());
        Assert.assertTrue((boolean)this.store.lookup(this.key2).isEmpty());
    }
}

