/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.decoding.impl;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml1.binding.decoding.impl.HTTPPostDecoder;
import org.opensaml.saml.saml1.core.Response;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Node;

public class HTTPPostDecoderTest
extends XMLObjectBaseTestCase {
    private String expectedRelayValue = "relay";
    private HTTPPostDecoder decoder;
    private MockHttpServletRequest httpRequest;
    private static final String INVALID_BASE64_TRAILING = "AB==";

    @BeforeMethod
    protected void setUp() throws Exception {
        this.httpRequest = new MockHttpServletRequest();
        this.httpRequest.setMethod("POST");
        this.httpRequest.setParameter("TARGET", this.expectedRelayValue);
        this.decoder = new HTTPPostDecoder();
        this.decoder.setParserPool(parserPool);
        this.decoder.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            public HttpServletRequest get() {
                return HTTPPostDecoderTest.this.httpRequest;
            }
        });
        this.decoder.initialize();
    }

    @Test
    public void testDecode() throws Exception {
        Response samlResponse = (Response)this.unmarshallElement("/org/opensaml/saml/saml1/binding/Response.xml");
        String deliveredEndpointURL = samlResponse.getRecipient();
        this.httpRequest.setParameter("SAMLResponse", this.encodeMessage((SAMLObject)samlResponse));
        this.populateRequestURL(this.httpRequest, deliveredEndpointURL);
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        Assert.assertTrue((boolean)(messageContext.getMessage() instanceof Response));
        Assert.assertEquals((String)SAMLBindingSupport.getRelayState((MessageContext)messageContext), (String)this.expectedRelayValue);
    }

    @Test
    public void testDecodeInvalidResponse() {
        block2: {
            this.httpRequest.setParameter("SAMLResponse", INVALID_BASE64_TRAILING);
            try {
                this.decoder.decode();
            }
            catch (MessageDecodingException e) {
                if (e.getCause() instanceof DecodingException) break block2;
                Assert.fail((String)"Expected DecodingException type");
            }
        }
    }

    private void populateRequestURL(MockHttpServletRequest request, String requestURL) {
        URL url = null;
        try {
            url = new URL(requestURL);
        }
        catch (MalformedURLException e) {
            Assert.fail((String)("Malformed URL: " + e.getMessage()));
        }
        request.setScheme(url.getProtocol());
        request.setServerName(url.getHost());
        if (url.getPort() != -1) {
            request.setServerPort(url.getPort());
        } else if ("https".equalsIgnoreCase(url.getProtocol())) {
            request.setServerPort(443);
        } else if ("http".equalsIgnoreCase(url.getProtocol())) {
            request.setServerPort(80);
        }
        request.setRequestURI(url.getPath());
        request.setQueryString(url.getQuery());
    }

    protected String encodeMessage(SAMLObject message) throws Exception {
        marshallerFactory.getMarshaller((XMLObject)message).marshall((XMLObject)message);
        String messageStr = SerializeSupport.nodeToString((Node)message.getDOM());
        return Base64Support.encode((byte[])messageStr.getBytes("UTF-8"), (boolean)false);
    }
}

