/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml1.core.Action;
import org.opensaml.saml.saml1.core.AuthorizationDecisionStatement;
import org.opensaml.saml.saml1.core.DecisionTypeEnumeration;
import org.opensaml.saml.saml1.core.Evidence;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.core.impl.AuthorizationDecisionStatementUnmarshaller;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuthorizationDecisionStatementTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final String expectedResource = "resource";
    private final DecisionTypeEnumeration expectedDecision = DecisionTypeEnumeration.PERMIT;
    private String illegalAttributesFile;

    public AuthorizationDecisionStatementTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAuthorizationDecisionStatement.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleAuthorizationDecisionStatementAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml1/impl/AuthorizationDecisionStatementWithChildren.xml";
        this.illegalAttributesFile = "/org/opensaml/saml/saml1/impl/singleAuthorizationDecisionStatementAttributesInvalid.xml";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        AuthorizationDecisionStatement authorizationDecisionStatement = (AuthorizationDecisionStatement)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)authorizationDecisionStatement.getDecision(), (String)"Decision attribute null");
        Assert.assertNull((Object)authorizationDecisionStatement.getResource(), (String)"Resource attribute null");
        Assert.assertEquals((int)authorizationDecisionStatement.getActions().size(), (int)0, (String)"<Actions> elements present");
        Assert.assertNull((Object)authorizationDecisionStatement.getEvidence(), (String)"<Evidence> element present");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AuthorizationDecisionStatement authorizationDecisionStatement = (AuthorizationDecisionStatement)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)authorizationDecisionStatement.getResource(), (String)"resource", (String)"Resource attribute ");
        Assert.assertEquals((String)authorizationDecisionStatement.getDecision().toString(), (String)this.expectedDecision.toString(), (String)"Decision attribute ");
        try {
            Document doc = parserPool.parse(((Object)((Object)this)).getClass().getResourceAsStream(this.illegalAttributesFile));
            Element samlElement = doc.getDocumentElement();
            authorizationDecisionStatement = (AuthorizationDecisionStatement)new AuthorizationDecisionStatementUnmarshaller().unmarshall(samlElement);
            Assert.fail((String)"illegal attribute successfully parsed");
        }
        catch (UnmarshallingException doc) {
        }
        catch (XMLParserException e) {
            Assert.fail((String)("couldn't parse file" + e));
            e.printStackTrace();
        }
    }

    @Test
    public void testChildElementsUnmarshall() {
        AuthorizationDecisionStatement authorizationDecisionStatement = (AuthorizationDecisionStatement)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)authorizationDecisionStatement.getSubject(), (String)"<Subject> element not present");
        Assert.assertNotNull((Object)authorizationDecisionStatement.getEvidence(), (String)"<Evidence> element not present");
        Assert.assertNotNull((Object)authorizationDecisionStatement.getActions(), (String)"<Action> elements not present");
        Assert.assertEquals((int)authorizationDecisionStatement.getActions().size(), (int)3, (String)"Count of <Action> elements ");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AuthorizationDecisionStatement authorizationDecisionStatement = (AuthorizationDecisionStatement)this.buildXMLObject(this.qname);
        authorizationDecisionStatement.setDecision(this.expectedDecision);
        authorizationDecisionStatement.setResource("resource");
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)authorizationDecisionStatement);
    }

    @Test
    public void testChildElementsMarshall() {
        AuthorizationDecisionStatement authorizationDecisionStatement = (AuthorizationDecisionStatement)this.buildXMLObject(this.qname);
        QName oqname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Subject", "saml1");
        authorizationDecisionStatement.setSubject((Subject)this.buildXMLObject(oqname));
        oqname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Action", "saml1");
        authorizationDecisionStatement.getActions().add((Action)this.buildXMLObject(oqname));
        authorizationDecisionStatement.getActions().add((Action)this.buildXMLObject(oqname));
        authorizationDecisionStatement.getActions().add((Action)this.buildXMLObject(oqname));
        oqname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Evidence", "saml1");
        authorizationDecisionStatement.setEvidence((Evidence)this.buildXMLObject(oqname));
        authorizationDecisionStatement.setEvidence((Evidence)this.buildXMLObject(oqname));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)authorizationDecisionStatement);
    }
}

