/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.profile.impl;

import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.DoNotCacheCondition;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.profile.impl.AddDoNotCacheConditionToAssertions;
import org.opensaml.saml.saml1.testing.SAML1ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AddDoNotCacheConditionToAssertionsTest
extends OpenSAMLInitBaseTestCase {
    @Test
    public void testNoResponse() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        AddDoNotCacheConditionToAssertions action = new AddDoNotCacheConditionToAssertions();
        action.initialize();
        action.execute(prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoAssertion() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)SAML1ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        AddDoNotCacheConditionToAssertions action = new AddDoNotCacheConditionToAssertions();
        action.initialize();
        action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
    }

    @Test
    public void testSingleAssertion() throws Exception {
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        AddDoNotCacheConditionToAssertions action = new AddDoNotCacheConditionToAssertions();
        action.initialize();
        action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getDoNotCacheConditions());
        Assert.assertEquals((int)assertion.getConditions().getDoNotCacheConditions().size(), (int)1);
    }

    @Test
    public void testSingleAssertionWithExistingCondition() throws Exception {
        SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsBuilder.buildObject();
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        assertion.setConditions(conditions);
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        AddDoNotCacheConditionToAssertions action = new AddDoNotCacheConditionToAssertions();
        action.initialize();
        action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getDoNotCacheConditions());
        Assert.assertEquals((int)assertion.getConditions().getDoNotCacheConditions().size(), (int)1);
    }

    @Test
    public void testSingleAssertionWithExistingDoNotCacheCondition() throws Exception {
        SAMLObjectBuilder dncConditionBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(DoNotCacheCondition.DEFAULT_ELEMENT_NAME);
        DoNotCacheCondition dncCondition = (DoNotCacheCondition)dncConditionBuilder.buildObject();
        SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsBuilder.buildObject();
        conditions.getDoNotCacheConditions().add(dncCondition);
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        assertion.setConditions(conditions);
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        AddDoNotCacheConditionToAssertions action = new AddDoNotCacheConditionToAssertions();
        action.initialize();
        action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getDoNotCacheConditions());
        Assert.assertEquals((int)assertion.getConditions().getDoNotCacheConditions().size(), (int)1);
    }

    @Test
    public void testMultipleAssertion() throws Exception {
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        AddDoNotCacheConditionToAssertions action = new AddDoNotCacheConditionToAssertions();
        action.initialize();
        action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)3);
        for (Assertion assertion : response.getAssertions()) {
            Assert.assertNotNull((Object)assertion.getConditions());
            Assert.assertNotNull((Object)assertion.getConditions().getDoNotCacheConditions());
            Assert.assertEquals((int)assertion.getConditions().getDoNotCacheConditions().size(), (int)1);
        }
    }
}

