/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.profile.impl;

import java.util.Arrays;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Status;
import org.opensaml.saml.saml1.core.StatusCode;
import org.opensaml.saml.saml1.profile.impl.AddStatusToResponse;
import org.opensaml.saml.saml1.testing.SAML1ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddStatusToResponseTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;
    private AddStatusToResponse action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc = new RequestContextBuilder().setOutboundMessage((Object)SAML1ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        this.action = new AddStatusToResponse();
    }

    @Test
    public void testMinimal() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Status status = response.getStatus();
        Assert.assertNotNull((Object)status);
        Assert.assertNotNull((Object)status.getStatusCode());
        Assert.assertEquals((Object)status.getStatusCode().getValue(), (Object)StatusCode.RESPONDER);
        Assert.assertNull((Object)status.getStatusCode().getStatusCode());
        Assert.assertNull((Object)status.getStatusMessage());
    }

    @Test
    public void testMultiStatus() throws ComponentInitializationException {
        this.action.setStatusCodes(Arrays.asList(StatusCode.REQUESTER, StatusCode.REQUEST_VERSION_DEPRECATED));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Status status = response.getStatus();
        Assert.assertNotNull((Object)status);
        Assert.assertNotNull((Object)status.getStatusCode());
        Assert.assertEquals((Object)status.getStatusCode().getValue(), (Object)StatusCode.REQUESTER);
        Assert.assertNotNull((Object)status.getStatusCode().getStatusCode());
        Assert.assertEquals((Object)status.getStatusCode().getStatusCode().getValue(), (Object)StatusCode.REQUEST_VERSION_DEPRECATED);
        Assert.assertNull((Object)status.getStatusCode().getStatusCode().getStatusCode());
        Assert.assertNull((Object)status.getStatusMessage());
    }

    @Test
    public void testFixedMessage() throws ComponentInitializationException {
        this.action.setStatusMessage("Foo");
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Status status = response.getStatus();
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((String)status.getStatusMessage().getValue(), (String)"Foo");
    }
}

