/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.profile.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.profile.impl.CopyNameIdentifierFromRequest;
import org.opensaml.saml.saml1.testing.SAML1ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CopyNameIdentifierFromRequestTest
extends OpenSAMLInitBaseTestCase {
    private static final String NAME_QUALIFIER = "https://idp.example.org";
    private ProfileRequestContext prc;
    private CopyNameIdentifierFromRequest action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new CopyNameIdentifierFromRequest();
        this.action.initialize();
    }

    @Test
    public void testNoResponse() {
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoAssertions() {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildResponse());
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertTrue((boolean)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().isEmpty());
    }

    @Test
    public void testNoRequest() {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildResponse());
        ((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        this.addStatements();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoName() {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildResponse());
        ((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        this.addStatements();
        this.prc.getInboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildAttributeQueryRequest(null));
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    void testCopy() {
        Subject subject = SAML1ActionTestingSupport.buildSubject((String)"jdoe");
        subject.getNameIdentifier().setNameQualifier(NAME_QUALIFIER);
        this.prc.getInboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildAttributeQueryRequest((Subject)subject));
        this.addStatements();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        subject = ((AttributeStatement)assertion.getAttributeStatements().get(0)).getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameIdentifier());
        Assert.assertEquals((String)subject.getNameIdentifier().getValue(), (String)"jdoe");
        Assert.assertEquals((String)subject.getNameIdentifier().getNameQualifier(), (String)NAME_QUALIFIER);
    }

    private void addStatements() {
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        ((Assertion)response.getAssertions().get(0)).getAttributeStatements().add(SAML1ActionTestingSupport.buildAttributeStatement());
        this.prc.getOutboundMessageContext().setMessage((Object)response);
    }
}

