/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import javax.annotation.Nonnull;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.impl.AbstractSubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.tests.BaseAssertionValidationTest;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractSubjectConfirmationValidatorTest
extends BaseAssertionValidationTest {
    private MockSubjectConfirmationValidator validator;
    private SubjectConfirmation subjectConfirmation;

    @BeforeMethod(dependsOnMethods={"setUpBasicAssertion"})
    public void setUp() {
        this.validator = new MockSubjectConfirmationValidator();
        this.subjectConfirmation = (SubjectConfirmation)this.getAssertion().getSubject().getSubjectConfirmations().get(0);
        this.subjectConfirmation.setMethod(this.validator.getServicedMethod());
    }

    @Test
    public void testValidConfirmationData() throws AssertionValidationException {
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testNoConfirmationData() throws AssertionValidationException {
        this.subjectConfirmation.setSubjectConfirmationData(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testInvalidAddress() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setAddress("1.2.3.4");
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidAddressWithAddressCheckDisabled() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setAddress("1.2.3.4");
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.CheckAddress", Boolean.FALSE);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testInvalidAddressParamType() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.ValidAddresses", "10.1.2.3");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testMissingAddressParam() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.remove("saml2.SubjectConfirmation.ValidAddresses");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testNoAddress() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setAddress(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testNoAddressAndRequired() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setAddress(null);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.AddressRequired", Boolean.TRUE);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testNoConfirmationDataAndAddressRequired() throws AssertionValidationException {
        this.subjectConfirmation.setSubjectConfirmationData(null);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.AddressRequired", Boolean.TRUE);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidRecipient() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setRecipient("https://bogussp.example.com");
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidRecipientParamType() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.ValidRecipients", "https://sp.example.com");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testMissingRecipientParam() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.remove("saml2.SubjectConfirmation.ValidRecipients");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testNoRecipient() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setRecipient(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testNoRecipientAndRequired() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setRecipient(null);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.RecipientRequired", Boolean.TRUE);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testNoConfirmationDataAndRecipientRequired() throws AssertionValidationException {
        this.subjectConfirmation.setSubjectConfirmationData(null);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.RecipientRequired", Boolean.TRUE);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidNotBefore() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setNotBefore(Instant.now().plus(30L, ChronoUnit.MINUTES));
        this.subjectConfirmation.getSubjectConfirmationData().setNotOnOrAfter(Instant.now().plus(60L, ChronoUnit.MINUTES));
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testNoNotBefore() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setNotBefore(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testNoNotBeforeAndRequired() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setNotBefore(null);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.NotBeforeRequired", Boolean.TRUE);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testNoConfirmationDataAndNotBeforeRequired() throws AssertionValidationException {
        this.subjectConfirmation.setSubjectConfirmationData(null);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.NotBeforeRequired", Boolean.TRUE);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidNotOnOrAfter() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setNotBefore(Instant.now().minus(60L, ChronoUnit.MINUTES));
        this.subjectConfirmation.getSubjectConfirmationData().setNotOnOrAfter(Instant.now().minus(30L, ChronoUnit.MINUTES));
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testNoNotOnOrAfter() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setNotOnOrAfter(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testNoNotOnOrAfterAndRequired() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setNotOnOrAfter(null);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.NoOnOrAfterRequired", Boolean.TRUE);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testNoConfirmationDataAndNotOnOrAfterRequired() throws AssertionValidationException {
        this.subjectConfirmation.setSubjectConfirmationData(null);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.NoOnOrAfterRequired", Boolean.TRUE);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidInResponseTo() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setInResponseTo("invalid");
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidInResponseToParamType() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.ValidInResponseTo", 42);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testMissingInResponseToParam() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.remove("saml2.SubjectConfirmation.ValidInResponseTo");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testNoInResponseTo() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setInResponseTo(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testNoInResponseToAndRequired() throws AssertionValidationException {
        this.subjectConfirmation.getSubjectConfirmationData().setInResponseTo(null);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.InResponseToRequired", Boolean.TRUE);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testNoConfirmationDataAndInResponseToRequired() throws AssertionValidationException {
        this.subjectConfirmation.setSubjectConfirmationData(null);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.InResponseToRequired", Boolean.TRUE);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    public static class MockSubjectConfirmationValidator
    extends AbstractSubjectConfirmationValidator {
        public String getServicedMethod() {
            return "urn:test:foo";
        }

        @Nonnull
        protected ValidationResult doValidate(@Nonnull SubjectConfirmation confirmation, @Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
            return ValidationResult.VALID;
        }
    }
}

