/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.impl.ProxyRestrictionConditionValidator;
import org.opensaml.saml.saml2.assertion.tests.BaseAssertionValidationTest;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.OneTimeUse;
import org.opensaml.saml.saml2.core.ProxyRestriction;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProxyRestrictionConditionValidatorTest
extends BaseAssertionValidationTest {
    private ProxyRestrictionConditionValidator validator;
    private Condition condition;

    @BeforeMethod(dependsOnMethods={"setUpBasicAssertion"})
    public void setUp() {
        this.validator = new ProxyRestrictionConditionValidator();
        this.condition = (Condition)this.buildXMLObject(ProxyRestriction.DEFAULT_ELEMENT_NAME);
        this.getAssertion().getConditions().getConditions().add(this.condition);
    }

    @Test
    public void testExpected() throws AssertionValidationException {
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.condition, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testUnexpected() throws AssertionValidationException {
        this.condition = (Condition)this.buildXMLObject(OneTimeUse.DEFAULT_ELEMENT_NAME);
        this.getAssertion().getConditions().getConditions().add(this.condition);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.condition, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }
}

