/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.impl;

import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.ECPContext;
import org.opensaml.saml.saml2.binding.impl.AddRequestAuthenticatedHeaderHandler;
import org.opensaml.saml.saml2.ecp.RequestAuthenticated;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AddRequestAuthenticatedHeaderHandlerTest
extends OpenSAMLInitBaseTestCase {
    @Test
    public void testUnauthenticated() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        AddRequestAuthenticatedHeaderHandler handler = new AddRequestAuthenticatedHeaderHandler();
        handler.initialize();
        handler.invoke(messageCtx);
        List headers = SOAPMessagingSupport.getHeaderBlock((MessageContext)messageCtx, (QName)RequestAuthenticated.DEFAULT_ELEMENT_NAME, null, (boolean)true);
        Assert.assertTrue((boolean)headers.isEmpty());
        ((ECPContext)messageCtx.getSubcontext(ECPContext.class, true)).setRequestAuthenticated(false);
        handler.invoke(messageCtx);
        headers = SOAPMessagingSupport.getHeaderBlock((MessageContext)messageCtx, (QName)RequestAuthenticated.DEFAULT_ELEMENT_NAME, null, (boolean)true);
        Assert.assertTrue((boolean)headers.isEmpty());
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testMissingEnvelope() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        ((ECPContext)messageCtx.getSubcontext(ECPContext.class, true)).setRequestAuthenticated(true);
        AddRequestAuthenticatedHeaderHandler handler = new AddRequestAuthenticatedHeaderHandler();
        handler.initialize();
        handler.invoke(messageCtx);
    }

    @Test
    public void testSuccess() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        ((ECPContext)messageCtx.getSubcontext(ECPContext.class, true)).setRequestAuthenticated(true);
        Envelope env = (Envelope)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Envelope.DEFAULT_ELEMENT_NAME).buildObject(Envelope.DEFAULT_ELEMENT_NAME);
        ((SOAP11Context)messageCtx.getSubcontext(SOAP11Context.class, true)).setEnvelope(env);
        AddRequestAuthenticatedHeaderHandler handler = new AddRequestAuthenticatedHeaderHandler();
        handler.initialize();
        handler.invoke(messageCtx);
        List headers = SOAPMessagingSupport.getHeaderBlock((MessageContext)messageCtx, (QName)RequestAuthenticated.DEFAULT_ELEMENT_NAME, null, (boolean)true);
        Assert.assertEquals((int)headers.size(), (int)1);
    }
}

