/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Advice;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AssertionIDRef;
import org.opensaml.saml.saml2.core.AssertionURIRef;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AdviceTest
extends XMLObjectProviderBaseTestCase {
    protected int assertionIDRefCount = 3;
    protected int assertionURIRefCount = 2;
    protected int assertionCount = 3;
    protected int encryptedAssertionCount = 2;

    public AdviceTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/Advice.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/AdviceChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        Advice advice = (Advice)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)advice);
    }

    @Test
    public void testChildElementsUnmarshall() {
        Advice advice = (Advice)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)advice.getAssertionIDReferences().size(), (int)this.assertionIDRefCount, (String)"AssertionIDRef count not as expected");
        Assert.assertEquals((int)advice.getAssertionURIReferences().size(), (int)this.assertionURIRefCount, (String)"AssertionURIRef count not as expected");
        Assert.assertEquals((int)advice.getAssertions().size(), (int)this.assertionCount, (String)"Assertion count not as expected");
        Assert.assertEquals((int)advice.getEncryptedAssertions().size(), (int)this.encryptedAssertionCount, (String)"EncryptedAssertion count not as expected");
    }

    @Test
    public void testSingleElementMarshall() {
        Advice advice = (Advice)this.buildXMLObject(Advice.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)advice);
    }

    @Test
    public void testChildElementsMarshall() {
        Advice advice = (Advice)this.buildXMLObject(Advice.DEFAULT_ELEMENT_NAME);
        advice.getChildren().add(this.buildXMLObject(AssertionIDRef.DEFAULT_ELEMENT_NAME));
        advice.getChildren().add(this.buildXMLObject(AssertionURIRef.DEFAULT_ELEMENT_NAME));
        advice.getChildren().add(this.buildXMLObject(AssertionIDRef.DEFAULT_ELEMENT_NAME));
        advice.getChildren().add(this.buildXMLObject(AssertionURIRef.DEFAULT_ELEMENT_NAME));
        advice.getChildren().add(this.buildXMLObject(AssertionIDRef.DEFAULT_ELEMENT_NAME));
        advice.getChildren().add(this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME));
        advice.getChildren().add(this.buildXMLObject(EncryptedAssertion.DEFAULT_ELEMENT_NAME));
        advice.getChildren().add(this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME));
        advice.getChildren().add(this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME));
        advice.getChildren().add(this.buildXMLObject(EncryptedAssertion.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)advice);
    }
}

