/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import java.time.Instant;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Advice;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.AuthzDecisionStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Subject;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AssertionTest
extends XMLObjectProviderBaseTestCase {
    private SAMLVersion expectedVersion;
    private Instant expectedIssueInstant;
    private String expectedID;
    private int statementCount = 7;
    private int authnStatementCount = 2;
    private int authzDecisionStatementCount = 2;
    private int attributeStatementCount = 3;

    public AssertionTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/Assertion.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/AssertionOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/AssertionChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedVersion = SAMLVersion.VERSION_20;
        this.expectedIssueInstant = Instant.parse("1984-08-26T10:01:30.043Z");
        this.expectedID = "id";
    }

    @Test
    public void testSingleElementUnmarshall() {
        Assertion assertion = (Assertion)this.unmarshallElement(this.singleElementFile);
        Instant notBefore = assertion.getIssueInstant();
        Assert.assertEquals((Object)notBefore, (Object)this.expectedIssueInstant, (String)("IssueInstant was " + notBefore + ", expected " + this.expectedIssueInstant));
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Assertion assertion = (Assertion)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Instant issueInstant = assertion.getIssueInstant();
        Assert.assertEquals((Object)issueInstant, (Object)this.expectedIssueInstant, (String)("IssueInstant was " + issueInstant + ", expected " + this.expectedIssueInstant));
        String id = assertion.getID();
        Assert.assertEquals((String)id, (String)this.expectedID, (String)("ID was " + id + ", expected " + this.expectedID));
        SAMLVersion version = assertion.getVersion();
        Assert.assertEquals((Object)version, (Object)this.expectedVersion, (String)("Version was " + version + ", expected " + this.expectedVersion));
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion", "saml2");
        Assertion assertion = (Assertion)this.buildXMLObject(qname);
        assertion.setIssueInstant(this.expectedIssueInstant);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)assertion);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME);
        ((Assertion)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion", "saml2");
        Assertion assertion = (Assertion)this.buildXMLObject(qname);
        assertion.setIssueInstant(this.expectedIssueInstant);
        assertion.setID(this.expectedID);
        assertion.setVersion(this.expectedVersion);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)assertion);
    }

    @Test
    public void testChildElementsUnmarshall() {
        Assertion assertion = (Assertion)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)assertion.getIssuer(), (String)"Issuer element not present");
        Assert.assertNotNull((Object)assertion.getSubject(), (String)"Subject element not present");
        Assert.assertNotNull((Object)assertion.getConditions(), (String)"Conditions element not present");
        Assert.assertNotNull((Object)assertion.getAdvice(), (String)"Advice element not present");
        Assert.assertEquals((int)assertion.getStatements().size(), (int)this.statementCount, (String)"Statement count not as expected");
        Assert.assertEquals((int)assertion.getAuthnStatements().size(), (int)this.authnStatementCount, (String)"AuthnStatement count not as expected");
        Assert.assertEquals((int)assertion.getAuthzDecisionStatements().size(), (int)this.authzDecisionStatementCount, (String)"AuthzDecisionStatment count not as expected");
        Assert.assertEquals((int)assertion.getAttributeStatements().size(), (int)this.attributeStatementCount, (String)"AttributeStatement count not as expected");
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion", "saml2");
        Assertion assertion = (Assertion)this.buildXMLObject(qname);
        QName issuerQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "saml2");
        assertion.setIssuer((Issuer)this.buildXMLObject(issuerQName));
        QName subjectQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Subject", "saml2");
        assertion.setSubject((Subject)this.buildXMLObject(subjectQName));
        QName conditionsQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Conditions", "saml2");
        assertion.setConditions((Conditions)this.buildXMLObject(conditionsQName));
        QName adviceQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Advice", "saml2");
        assertion.setAdvice((Advice)this.buildXMLObject(adviceQName));
        QName authnStatementQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnStatement", "saml2");
        for (int i = 0; i < this.authnStatementCount; ++i) {
            assertion.getAuthnStatements().add((AuthnStatement)this.buildXMLObject(authnStatementQName));
        }
        QName authzDecisionStatementQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthzDecisionStatement", "saml2");
        for (int i = 0; i < this.authzDecisionStatementCount; ++i) {
            assertion.getAuthzDecisionStatements().add((AuthzDecisionStatement)this.buildXMLObject(authzDecisionStatementQName));
        }
        QName attributeStatementQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AttributeStatement", "saml2");
        for (int i = 0; i < this.attributeStatementCount; ++i) {
            assertion.getAttributeStatements().add((AttributeStatement)this.buildXMLObject(attributeStatementQName));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)assertion);
    }

    @Test(expectedExceptions={UnmarshallingException.class})
    public void testBadSAMLVersion() throws XMLParserException, UnmarshallingException {
        this.unmarshallElement("/org/opensaml/saml/saml2/core/impl/AssertionBadSAMLVersion.xml", true);
    }
}

