/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.impl.SubjectQueryTestBase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeQueryTest
extends SubjectQueryTestBase {
    private int expectedNumAttributes;

    public AttributeQueryTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/AttributeQuery.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/AttributeQueryOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/AttributeQueryChildElements.xml";
    }

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
        this.expectedNumAttributes = 4;
    }

    @Override
    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AttributeQuery", "saml2p");
        AttributeQuery query = (AttributeQuery)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)query);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)query);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(AttributeQuery.DEFAULT_ELEMENT_NAME);
        ((AttributeQuery)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AttributeQuery", "saml2p");
        AttributeQuery query = (AttributeQuery)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)query);
        super.populateOptionalAttributes((SAMLObject)query);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)query);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AttributeQuery", "saml2p");
        AttributeQuery query = (AttributeQuery)this.buildXMLObject(qname);
        this.populateChildElements((SAMLObject)query);
        QName attributeQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Attribute", "saml2");
        for (int i = 0; i < this.expectedNumAttributes; ++i) {
            query.getAttributes().add((Attribute)this.buildXMLObject(attributeQName));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)query);
    }

    @Override
    @Test
    public void testSingleElementUnmarshall() {
        AttributeQuery query = (AttributeQuery)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)query, (String)"AttributeQuery was null");
        super.helperTestSingleElementUnmarshall((SAMLObject)query);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AttributeQuery query = (AttributeQuery)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)query, (String)"AttributeQuery was null");
        super.helperTestSingleElementOptionalAttributesUnmarshall((SAMLObject)query);
    }

    @Test
    public void testChildElementsUnmarshall() {
        AttributeQuery query = (AttributeQuery)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)query.getAttributes().size(), (int)this.expectedNumAttributes, (String)"Attribute count");
        super.helperTestChildElementsUnmarshall((SAMLObject)query);
    }
}

