/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.Action;
import org.opensaml.saml.saml2.core.AuthzDecisionStatement;
import org.opensaml.saml.saml2.core.DecisionTypeEnumeration;
import org.opensaml.saml.saml2.core.Evidence;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuthzDecisionStatementTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedResource;
    protected DecisionTypeEnumeration expectedDecision;
    protected int expectedActionCount = 3;

    public AuthzDecisionStatementTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/AuthzDecisionStatement.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/AuthzDecisionStatementOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/AuthzDecisionStatementChildElements.xml";
        this.invalidFile = "/org/opensaml/saml/saml2/core/impl/AuthzDecisionStatementInvalidDecision.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedResource = "resource name";
        this.expectedDecision = DecisionTypeEnumeration.DENY;
    }

    @Test(expectedExceptions={UnmarshallingException.class})
    public void testInvalidUnmarshall() throws XMLParserException, UnmarshallingException {
        this.unmarshallElement(this.invalidFile, true);
    }

    @Test
    public void testSingleElementUnmarshall() {
        AuthzDecisionStatement authzDecisionStatement = (AuthzDecisionStatement)this.unmarshallElement(this.singleElementFile);
        String resource = authzDecisionStatement.getResource();
        Assert.assertEquals((String)resource, (String)this.expectedResource, (String)"Resource not as expected");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AuthzDecisionStatement authzDecisionStatement = (AuthzDecisionStatement)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        String resource = authzDecisionStatement.getResource();
        Assert.assertEquals((String)resource, (String)this.expectedResource, (String)"Resource not as expected");
        DecisionTypeEnumeration decision = authzDecisionStatement.getDecision();
        Assert.assertEquals((String)decision.toString(), (String)this.expectedDecision.toString(), (String)"Decision not as expected");
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthzDecisionStatement", "saml2");
        AuthzDecisionStatement authzDecisionStatement = (AuthzDecisionStatement)this.buildXMLObject(qname);
        authzDecisionStatement.setResource(this.expectedResource);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)authzDecisionStatement);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthzDecisionStatement", "saml2");
        AuthzDecisionStatement authzDecisionStatement = (AuthzDecisionStatement)this.buildXMLObject(qname);
        authzDecisionStatement.setResource(this.expectedResource);
        authzDecisionStatement.setDecision(this.expectedDecision);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)authzDecisionStatement);
    }

    @Test
    public void testChildElementsUnmarshall() {
        AuthzDecisionStatement authzDecisionStatement = (AuthzDecisionStatement)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)authzDecisionStatement.getActions().size(), (int)this.expectedActionCount, (String)"Action Count");
        Assert.assertNotNull((Object)authzDecisionStatement.getEvidence(), (String)"Evidence element not present");
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthzDecisionStatement", "saml2");
        AuthzDecisionStatement authzDecisionStatement = (AuthzDecisionStatement)this.buildXMLObject(qname);
        QName actionQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Action", "saml2");
        for (int i = 0; i < this.expectedActionCount; ++i) {
            authzDecisionStatement.getActions().add((Action)this.buildXMLObject(actionQName));
        }
        QName evidenceQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Evidence", "saml2");
        authzDecisionStatement.setEvidence((Evidence)this.buildXMLObject(evidenceQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)authzDecisionStatement);
    }

    public void testResource() {
        AuthzDecisionStatement authzDecisionStatement = (AuthzDecisionStatement)this.buildXMLObject(AuthzDecisionStatement.DEFAULT_ELEMENT_NAME);
        authzDecisionStatement.setResource("urn:test:foo");
        Assert.assertEquals((String)authzDecisionStatement.getResource(), (String)"urn:test:foo");
        authzDecisionStatement.setResource("");
        Assert.assertEquals((String)authzDecisionStatement.getResource(), (String)"");
        authzDecisionStatement.setResource("   ");
        Assert.assertEquals((String)authzDecisionStatement.getResource(), (String)"   ");
    }
}

