/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import java.time.Instant;
import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.Conditions;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ConditionsTest
extends XMLObjectProviderBaseTestCase {
    private Instant expectedNotBefore;
    private Instant expectedNotOnOrAfter;
    private int conditionCount = 6;
    private int audienceRestrictionCount = 3;

    public ConditionsTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/Conditions.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/ConditionsOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/ConditionsChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedNotBefore = Instant.parse("1984-08-26T10:01:30.043Z");
        this.expectedNotOnOrAfter = Instant.parse("1984-08-26T10:11:30.043Z");
    }

    @Test
    public void testSingleElementUnmarshall() {
        Conditions conditions = (Conditions)this.unmarshallElement(this.singleElementFile);
        Instant notBefore = conditions.getNotBefore();
        Assert.assertEquals((Object)notBefore, (Object)this.expectedNotBefore, (String)("NotBefore was " + notBefore + ", expected " + this.expectedNotBefore));
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Conditions conditions = (Conditions)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Instant notBefore = conditions.getNotBefore();
        Assert.assertEquals((Object)notBefore, (Object)this.expectedNotBefore, (String)("NotBefore was " + notBefore + ", expected " + this.expectedNotBefore));
        Instant notOnOrAfter = conditions.getNotOnOrAfter();
        Assert.assertEquals((Object)notOnOrAfter, (Object)this.expectedNotOnOrAfter, (String)("NotOnOrAfter was " + notOnOrAfter + ", expected " + this.expectedNotOnOrAfter));
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Conditions", "saml2");
        Conditions conditions = (Conditions)this.buildXMLObject(qname);
        conditions.setNotBefore(this.expectedNotBefore);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)conditions);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Conditions", "saml2");
        Conditions conditions = (Conditions)this.buildXMLObject(qname);
        conditions.setNotBefore(this.expectedNotBefore);
        conditions.setNotOnOrAfter(this.expectedNotOnOrAfter);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)conditions);
    }

    @Test
    public void testChildElementsUnmarshall() {
        Conditions conditions = (Conditions)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)conditions.getConditions().size(), (int)this.conditionCount, (String)"Condition count not as expected");
        Assert.assertNotNull((Object)conditions.getOneTimeUse(), (String)"OneTimeUse absent");
        Assert.assertNotNull((Object)conditions.getProxyRestriction(), (String)"ProxyRestriction absent");
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Conditions", "saml2");
        Conditions conditions = (Conditions)this.buildXMLObject(qname);
        QName oneTimeUserQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "OneTimeUse", "saml2");
        conditions.getConditions().add((Condition)this.buildXMLObject(oneTimeUserQName));
        QName audienceRestrictionQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AudienceRestriction", "saml2");
        for (int i = 0; i < this.audienceRestrictionCount; ++i) {
            conditions.getAudienceRestrictions().add((AudienceRestriction)this.buildXMLObject(audienceRestrictionQName));
        }
        conditions.getConditions().add((Condition)this.buildXMLObject(oneTimeUserQName));
        QName proxyRestrictionQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "ProxyRestriction", "saml2");
        conditions.getConditions().add((Condition)this.buildXMLObject(proxyRestrictionQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)conditions);
    }
}

