/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Extensions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ExtensionsTest
extends XMLObjectProviderBaseTestCase {
    public ExtensionsTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/Extensions.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/ExtensionsChildElements.xml";
    }

    @Test
    public void testSingleElementMarshall() {
        Extensions extensions = (Extensions)this.buildXMLObject(Extensions.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)extensions);
    }

    @Test
    public void testChildElementsMarshall() {
        Extensions extensions = (Extensions)this.buildXMLObject(Extensions.DEFAULT_ELEMENT_NAME);
        QName childQname = new QName("http://www.example.org/testObjects", "SimpleElement", "test");
        extensions.getUnknownXMLObjects().add(this.buildXMLObject(childQname));
        extensions.getUnknownXMLObjects().add(this.buildXMLObject(childQname));
        extensions.getUnknownXMLObjects().add(this.buildXMLObject(childQname));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)extensions);
    }

    @Test
    public void testSingleElementUnmarshall() {
        Extensions extensions = (Extensions)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)extensions);
    }

    @Test
    public void testChildElementsUnmarshall() {
        Extensions extensions = (Extensions)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)extensions);
        Assert.assertEquals((int)extensions.getUnknownXMLObjects().size(), (int)3);
    }
}

