/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.GetComplete;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.opensaml.saml.saml2.core.IDPList;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class IDPListTest
extends XMLObjectProviderBaseTestCase {
    private int expectedNumIDPEntryChildren;

    public IDPListTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/IDPList.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/IDPListChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedNumIDPEntryChildren = 3;
    }

    @Test
    public void testSingleElementMarshall() {
        IDPList list = (IDPList)this.buildXMLObject(IDPList.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)list);
    }

    @Test
    public void testChildElementsMarshall() {
        IDPList list = (IDPList)this.buildXMLObject(IDPList.DEFAULT_ELEMENT_NAME);
        QName idpEntryQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "IDPEntry", "saml2p");
        for (int i = 0; i < this.expectedNumIDPEntryChildren; ++i) {
            list.getIDPEntrys().add((IDPEntry)this.buildXMLObject(idpEntryQName));
        }
        QName getCompelteQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "GetComplete", "saml2p");
        list.setGetComplete((GetComplete)this.buildXMLObject(getCompelteQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)list);
    }

    @Test
    public void testSingleElementUnmarshall() {
        IDPList list = (IDPList)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)list, (String)"IDPList");
        Assert.assertEquals((int)list.getIDPEntrys().size(), (int)0, (String)"IDPEntry count");
        Assert.assertNull((Object)list.getGetComplete(), (String)"GetComplete");
    }

    @Test
    public void testChildElementsUnmarshall() {
        IDPList list = (IDPList)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)list.getIDPEntrys().size(), (int)this.expectedNumIDPEntryChildren, (String)"IDPEntry count");
        Assert.assertNotNull((Object)list.getGetComplete(), (String)"GetComplete");
    }
}

