/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.ManageNameIDRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NewID;
import org.opensaml.saml.saml2.core.impl.RequestTestBase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ManageNameIDRequestTest
extends RequestTestBase {
    public ManageNameIDRequestTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/ManageNameIDRequest.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/ManageNameIDRequestOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/ManageNameIDRequestChildElements.xml";
    }

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "ManageNameIDRequest", "saml2p");
        ManageNameIDRequest req = (ManageNameIDRequest)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)req);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)req);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(ManageNameIDRequest.DEFAULT_ELEMENT_NAME);
        ((ManageNameIDRequest)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "ManageNameIDRequest", "saml2p");
        ManageNameIDRequest req = (ManageNameIDRequest)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)req);
        super.populateOptionalAttributes((SAMLObject)req);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)req);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "ManageNameIDRequest", "saml2p");
        ManageNameIDRequest req = (ManageNameIDRequest)this.buildXMLObject(qname);
        super.populateChildElements((SAMLObject)req);
        QName nameIDQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "NameID", "saml2");
        req.setNameID((NameID)this.buildXMLObject(nameIDQName));
        QName newIDQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "NewID", "saml2p");
        req.setNewID((NewID)this.buildXMLObject(newIDQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)req);
    }

    @Override
    @Test
    public void testSingleElementUnmarshall() {
        ManageNameIDRequest req = (ManageNameIDRequest)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)req, (String)"ManageNameIDRequest was null");
        super.helperTestSingleElementUnmarshall((SAMLObject)req);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        ManageNameIDRequest req = (ManageNameIDRequest)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)req, (String)"ManageNameIDRequest was null");
        super.helperTestSingleElementOptionalAttributesUnmarshall((SAMLObject)req);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ManageNameIDRequest req = (ManageNameIDRequest)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)req.getNameID(), (String)"NameID was null");
        Assert.assertNotNull((Object)req.getNewID(), (String)"NewID was null");
        super.helperTestChildElementsUnmarshall((SAMLObject)req);
    }
}

