/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDMappingRequest;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.impl.RequestTestBase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class NameIDMappingRequestTest
extends RequestTestBase {
    public NameIDMappingRequestTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/NameIDMappingRequest.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/NameIDMappingRequestOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/NameIDMappingRequestChildElements.xml";
    }

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "NameIDMappingRequest", "saml2p");
        NameIDMappingRequest req = (NameIDMappingRequest)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)req);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)req);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(NameIDMappingRequest.DEFAULT_ELEMENT_NAME);
        ((NameIDMappingRequest)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "NameIDMappingRequest", "saml2p");
        NameIDMappingRequest req = (NameIDMappingRequest)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)req);
        super.populateOptionalAttributes((SAMLObject)req);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)req);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "NameIDMappingRequest", "saml2p");
        NameIDMappingRequest req = (NameIDMappingRequest)this.buildXMLObject(qname);
        super.populateChildElements((SAMLObject)req);
        QName nameIDQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "NameID", "saml2");
        req.setNameID((NameID)this.buildXMLObject(nameIDQName));
        QName nameIDPolicyQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "NameIDPolicy", "saml2p");
        req.setNameIDPolicy((NameIDPolicy)this.buildXMLObject(nameIDPolicyQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)req);
    }

    @Override
    @Test
    public void testSingleElementUnmarshall() {
        NameIDMappingRequest req = (NameIDMappingRequest)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)req, (String)"NameIDMappingRequest was null");
        super.helperTestSingleElementUnmarshall((SAMLObject)req);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        NameIDMappingRequest req = (NameIDMappingRequest)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)req, (String)"NameIDMappingRequest was null");
        super.helperTestSingleElementOptionalAttributesUnmarshall((SAMLObject)req);
    }

    @Test
    public void testChildElementsUnmarshall() {
        NameIDMappingRequest req = (NameIDMappingRequest)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)req.getNameID(), (String)"Identifier was null");
        Assert.assertNotNull((Object)req.getNameIDPolicy(), (String)"NameIDPolicy was null");
        super.helperTestChildElementsUnmarshall((SAMLObject)req);
    }
}

