/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.ProxyRestriction;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ProxyRestrictionTest
extends XMLObjectProviderBaseTestCase {
    protected int expectedCount = 5;
    protected int expectedAudienceCount = 2;

    public ProxyRestrictionTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/ProxyRestriction.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/ProxyRestrictionChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        ProxyRestriction proxyRestriction = (ProxyRestriction)this.unmarshallElement(this.singleElementFile);
        int count = proxyRestriction.getProxyCount();
        Assert.assertEquals((int)count, (int)this.expectedCount, (String)"ProxyCount not as expected");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "ProxyRestriction", "saml2");
        ProxyRestriction proxyRestriction = (ProxyRestriction)this.buildXMLObject(qname);
        proxyRestriction.setProxyCount(Integer.valueOf(this.expectedCount));
        this.assertXMLEquals(this.expectedDOM, (XMLObject)proxyRestriction);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
    }

    @Test
    public void testChildElementsUnmarshall() {
        ProxyRestriction proxyRestriction = (ProxyRestriction)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)proxyRestriction.getAudiences().size(), (int)this.expectedAudienceCount, (String)"Audience Count");
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "ProxyRestriction", "saml2");
        ProxyRestriction proxyRestriction = (ProxyRestriction)this.buildXMLObject(qname);
        QName audienceQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Audience", "saml2");
        for (int i = 0; i < this.expectedAudienceCount; ++i) {
            proxyRestriction.getAudiences().add((Audience)this.buildXMLObject(audienceQName));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)proxyRestriction);
    }
}

