/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StatusTest
extends XMLObjectProviderBaseTestCase {
    public StatusTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/Status.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/StatusChildElements.xml";
    }

    @Test
    public void testSingleElementMarshall() {
        Status status = (Status)this.buildXMLObject(Status.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)status);
    }

    @Test
    public void testChildElementsMarshall() {
        Status status = (Status)this.buildXMLObject(Status.DEFAULT_ELEMENT_NAME);
        QName statusCodeQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "StatusCode", "saml2p");
        status.setStatusCode((StatusCode)this.buildXMLObject(statusCodeQName));
        QName statusMessageQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "StatusMessage", "saml2p");
        status.setStatusMessage((StatusMessage)this.buildXMLObject(statusMessageQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)status);
    }

    @Test
    public void testSingleElementUnmarshall() {
        Status status = (Status)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)status, (String)"Status");
        Assert.assertNull((Object)status.getStatusCode(), (String)"StatusCode child");
        Assert.assertNull((Object)status.getStatusMessage(), (String)"StatusMessage");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Status status = (Status)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)status.getStatusCode(), (String)"StatusCode of Status was null");
        Assert.assertNotNull((Object)status.getStatusMessage(), (String)"StatusMessage of Status was null");
    }
}

