/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SubjectTest
extends XMLObjectProviderBaseTestCase {
    protected int expectedSubjectConfirmationCount = 2;

    public SubjectTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/Subject.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/SubjectChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        Subject subject = (Subject)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)subject);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Subject", "saml2");
        Subject subject = (Subject)this.buildXMLObject(qname);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)subject);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
    }

    @Test
    public void testChildElementsUnmarshall() {
        Subject subject = (Subject)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)subject.getNameID(), (String)"Identifier element not present");
        Assert.assertEquals((int)subject.getSubjectConfirmations().size(), (int)this.expectedSubjectConfirmationCount, (String)"SubjectConfirmation Count not as expected");
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Subject", "saml2");
        Subject subject = (Subject)this.buildXMLObject(qname);
        QName nameIDQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "NameID", "saml2");
        subject.setNameID((NameID)this.buildXMLObject(nameIDQName));
        QName subjectConfirmationQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmation", "saml2");
        for (int i = 0; i < this.expectedSubjectConfirmationCount; ++i) {
            subject.getSubjectConfirmations().add((SubjectConfirmation)this.buildXMLObject(subjectConfirmationQName));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)subject);
    }
}

