/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.ecp.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.ecp.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ResponseTest
extends XMLObjectProviderBaseTestCase {
    private String expectedACSURL;
    private String expectedSOAP11Actor;
    private Boolean expectedSOAP11MustUnderstand;

    public ResponseTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/ecp/impl/Response.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedACSURL = "https://sp.example.org/acs";
        this.expectedSOAP11Actor = "https://soap11actor.example.org";
        this.expectedSOAP11MustUnderstand = true;
    }

    @Test
    public void testSingleElementUnmarshall() {
        Response response = (Response)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)response.isSOAP11MustUnderstand(), (Object)this.expectedSOAP11MustUnderstand, (String)"SOAP mustUnderstand had unxpected value");
        Assert.assertEquals((String)response.getSOAP11Actor(), (String)this.expectedSOAP11Actor, (String)"SOAP actor had unxpected value");
        Assert.assertEquals((String)response.getAssertionConsumerServiceURL(), (String)this.expectedACSURL, (String)"ACS URL had unexpected value");
    }

    @Test
    public void testSingleElementMarshall() {
        Response response = (Response)this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME);
        response.setSOAP11Actor(this.expectedSOAP11Actor);
        response.setSOAP11MustUnderstand(this.expectedSOAP11MustUnderstand);
        response.setAssertionConsumerServiceURL(this.expectedACSURL);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)response);
    }
}

