/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.encryption.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EncryptedElementTypeEncryptedKeyResolverTest
extends XMLObjectBaseTestCase {
    private EncryptedElementTypeEncryptedKeyResolver resolver;

    @Test
    public void testSingleEKNoRecipients() {
        String filename = "/org/opensaml/saml/saml2/encryption/EncryptedElementTypeEncryptedKeyResolverSingleNoRecipient.xml";
        EncryptedAssertion encAssertion = (EncryptedAssertion)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)encAssertion.getEncryptedData());
        EncryptedData encData = encAssertion.getEncryptedData();
        List allKeys = encAssertion.getEncryptedKeys();
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new EncryptedElementTypeEncryptedKeyResolver();
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testSingleEKMultiRecipientWithImplicitMatch() {
        String filename = "/org/opensaml/saml/saml2/encryption/EncryptedElementTypeEncryptedKeyResolverSingleNoRecipient.xml";
        EncryptedAssertion encAssertion = (EncryptedAssertion)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)encAssertion.getEncryptedData());
        EncryptedData encData = encAssertion.getEncryptedData();
        List allKeys = encAssertion.getEncryptedKeys();
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new EncryptedElementTypeEncryptedKeyResolver(new HashSet<String>(Arrays.asList("foo", "bar", "baz")));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testSingleEKOneRecipientWithMatch() {
        String filename = "/org/opensaml/saml/saml2/encryption/EncryptedElementTypeEncryptedKeyResolverSingleWithRecipient.xml";
        EncryptedAssertion encAssertion = (EncryptedAssertion)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)encAssertion.getEncryptedData());
        EncryptedData encData = encAssertion.getEncryptedData();
        List allKeys = encAssertion.getEncryptedKeys();
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new EncryptedElementTypeEncryptedKeyResolver(Collections.singleton("foo"));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testSingleEKOneRecipientNoMatch() {
        String filename = "/org/opensaml/saml/saml2/encryption/EncryptedElementTypeEncryptedKeyResolverSingleWithRecipient.xml";
        EncryptedAssertion encAssertion = (EncryptedAssertion)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)encAssertion.getEncryptedData());
        EncryptedData encData = encAssertion.getEncryptedData();
        List allKeys = encAssertion.getEncryptedKeys();
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new EncryptedElementTypeEncryptedKeyResolver(Collections.singleton("bar"));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)0, (String)"Incorrect number of resolved EncryptedKeys found");
    }

    @Test
    public void testMultiEKNoRecipients() {
        String filename = "/org/opensaml/saml/saml2/encryption/EncryptedElementTypeEncryptedKeyResolverMultiple.xml";
        EncryptedAssertion encAssertion = (EncryptedAssertion)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)encAssertion.getEncryptedData());
        EncryptedData encData = encAssertion.getEncryptedData();
        List allKeys = encAssertion.getEncryptedKeys();
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new EncryptedElementTypeEncryptedKeyResolver();
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)4, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(1) == allKeys.get(1) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(2) == allKeys.get(2) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(3) == allKeys.get(3) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testMultiEKOneRecipientWithMatch() {
        String filename = "/org/opensaml/saml/saml2/encryption/EncryptedElementTypeEncryptedKeyResolverMultiple.xml";
        EncryptedAssertion encAssertion = (EncryptedAssertion)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)encAssertion.getEncryptedData());
        EncryptedData encData = encAssertion.getEncryptedData();
        List allKeys = encAssertion.getEncryptedKeys();
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new EncryptedElementTypeEncryptedKeyResolver(Collections.singleton("foo"));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)2, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(1) == allKeys.get(2) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testMultiEKOneRecipientWithMatches() {
        String filename = "/org/opensaml/saml/saml2/encryption/EncryptedElementTypeEncryptedKeyResolverMultiple.xml";
        EncryptedAssertion encAssertion = (EncryptedAssertion)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)encAssertion.getEncryptedData());
        EncryptedData encData = encAssertion.getEncryptedData();
        List allKeys = encAssertion.getEncryptedKeys();
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new EncryptedElementTypeEncryptedKeyResolver(new HashSet<String>(Arrays.asList("foo", "baz")));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)3, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(1) == allKeys.get(2) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(2) == allKeys.get(3) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    private List<EncryptedKey> generateList(EncryptedData encData, EncryptedKeyResolver ekResolver) {
        ArrayList<EncryptedKey> resolved = new ArrayList<EncryptedKey>();
        for (EncryptedKey encKey : ekResolver.resolve(encData)) {
            resolved.add(encKey);
        }
        return resolved;
    }
}

