/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.encryption.tests;

import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.SecretKey;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NewEncryptedID;
import org.opensaml.saml.saml2.core.NewID;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class SimpleDecryptionTest
extends XMLObjectBaseTestCase {
    private KeyInfoCredentialResolver keyResolver;
    private String encURI = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    private DataEncryptionParameters encParams;
    private Encrypter encrypter;

    @BeforeMethod
    protected void setUp() throws Exception {
        Credential encCred = AlgorithmSupport.generateSymmetricKeyAndCredential((String)this.encURI);
        encCred.getSecretKey();
        this.keyResolver = new StaticKeyInfoCredentialResolver(encCred);
        this.encParams = new DataEncryptionParameters();
        this.encParams.setAlgorithm(this.encURI);
        this.encParams.setEncryptionCredential(encCred);
        this.encrypter = new Encrypter(this.encParams);
    }

    @Test
    public void testEncryptedAssertion() throws XMLParserException, EncryptionException {
        String filename = "/org/opensaml/saml/saml2/encryption/Assertion.xml";
        Document targetDOM = this.getDOM(filename);
        Assertion target = (Assertion)this.unmarshallElement(filename);
        EncryptedAssertion encryptedTarget = this.encrypter.encrypt(target);
        Decrypter decrypter = new Decrypter(this.keyResolver, null, null);
        Assertion decryptedTarget = null;
        try {
            decryptedTarget = decrypter.decrypt(encryptedTarget);
        }
        catch (DecryptionException e) {
            Assert.fail((String)("Error on decryption of encrypted SAML 2 type to element: " + e));
        }
        Assert.assertNotNull((Object)decryptedTarget, (String)"Decrypted target was null");
        Assert.assertTrue((boolean)(decryptedTarget instanceof Assertion), (String)"Decrypted target was not the expected type");
        this.assertXMLEquals(targetDOM, (XMLObject)decryptedTarget);
    }

    @Test
    public void testEncryptedAssertionAsID() throws XMLParserException, EncryptionException {
        String filename = "/org/opensaml/saml/saml2/encryption/Assertion.xml";
        Document targetDOM = this.getDOM(filename);
        Assertion target = (Assertion)this.unmarshallElement(filename);
        EncryptedID encryptedTarget = this.encrypter.encryptAsID(target);
        Decrypter decrypter = new Decrypter(this.keyResolver, null, null);
        SAMLObject decryptedTarget = null;
        try {
            decryptedTarget = decrypter.decrypt(encryptedTarget);
        }
        catch (DecryptionException e) {
            Assert.fail((String)("Error on decryption of encrypted SAML 2 type to element: " + e));
        }
        Assert.assertNotNull((Object)decryptedTarget, (String)"Decrypted target was null");
        Assert.assertTrue((boolean)(decryptedTarget instanceof Assertion), (String)"Decrypted target was not the expected type");
        this.assertXMLEquals(targetDOM, (XMLObject)decryptedTarget);
    }

    @Test
    public void testEncryptedNameID() throws XMLParserException, EncryptionException {
        String filename = "/org/opensaml/saml/saml2/encryption/NameID.xml";
        Document targetDOM = this.getDOM(filename);
        NameID target = (NameID)this.unmarshallElement(filename);
        EncryptedID encryptedTarget = this.encrypter.encrypt(target);
        Decrypter decrypter = new Decrypter(this.keyResolver, null, null);
        SAMLObject decryptedTarget = null;
        try {
            decryptedTarget = decrypter.decrypt(encryptedTarget);
        }
        catch (DecryptionException e) {
            Assert.fail((String)("Error on decryption of encrypted SAML 2 type to element: " + e));
        }
        Assert.assertNotNull((Object)decryptedTarget, (String)"Decrypted target was null");
        Assert.assertTrue((boolean)(decryptedTarget instanceof NameID), (String)"Decrypted target was not the expected type");
        this.assertXMLEquals(targetDOM, (XMLObject)decryptedTarget);
    }

    @Test
    public void testEncryptedNewID() throws XMLParserException, EncryptionException {
        String filename = "/org/opensaml/saml/saml2/encryption/NewID.xml";
        Document targetDOM = this.getDOM(filename);
        NewID target = (NewID)this.unmarshallElement(filename);
        NewEncryptedID encryptedTarget = this.encrypter.encrypt(target);
        Decrypter decrypter = new Decrypter(this.keyResolver, null, null);
        NewID decryptedTarget = null;
        try {
            decryptedTarget = decrypter.decrypt(encryptedTarget);
        }
        catch (DecryptionException e) {
            Assert.fail((String)("Error on decryption of encrypted SAML 2 type to element: " + e));
        }
        Assert.assertNotNull((Object)decryptedTarget, (String)"Decrypted target was null");
        Assert.assertTrue((boolean)(decryptedTarget instanceof NewID), (String)"Decrypted target was not the expected type");
        this.assertXMLEquals(targetDOM, (XMLObject)decryptedTarget);
    }

    @Test
    public void testEncryptedAttribute() throws XMLParserException, EncryptionException {
        String filename = "/org/opensaml/saml/saml2/encryption/Attribute.xml";
        Document targetDOM = this.getDOM(filename);
        Attribute target = (Attribute)this.unmarshallElement(filename);
        EncryptedAttribute encryptedTarget = this.encrypter.encrypt(target);
        Decrypter decrypter = new Decrypter(this.keyResolver, null, null);
        Attribute decryptedTarget = null;
        try {
            decryptedTarget = decrypter.decrypt(encryptedTarget);
        }
        catch (DecryptionException e) {
            Assert.fail((String)("Error on decryption of encrypted SAML 2 type to element: " + e));
        }
        Assert.assertNotNull((Object)decryptedTarget, (String)"Decrypted target was null");
        Assert.assertTrue((boolean)(decryptedTarget instanceof Attribute), (String)"Decrypted target was not the expected type");
        this.assertXMLEquals(targetDOM, (XMLObject)decryptedTarget);
    }

    @Test
    public void testErrorInvalidDataDecryptionKey() throws XMLParserException, EncryptionException, NoSuchAlgorithmException, NoSuchProviderException, KeyException {
        SecretKey badKey = AlgorithmSupport.generateSymmetricKey((String)this.encURI);
        BasicCredential encCred = new BasicCredential(badKey);
        StaticKeyInfoCredentialResolver badEncResolver = new StaticKeyInfoCredentialResolver((Credential)encCred);
        String filename = "/org/opensaml/saml/saml2/encryption/Assertion.xml";
        Assertion target = (Assertion)this.unmarshallElement(filename);
        EncryptedAssertion encryptedTarget = this.encrypter.encrypt(target);
        Decrypter decrypter = new Decrypter((KeyInfoCredentialResolver)badEncResolver, null, null);
        try {
            decrypter.decrypt(encryptedTarget);
            Assert.fail((String)"Decryption should have failed due to bad decryption key");
        }
        catch (DecryptionException decryptionException) {
            // empty catch block
        }
    }

    private Document getDOM(String filename) throws XMLParserException {
        Document targetDOM = parserPool.parse(SimpleDecryptionTest.class.getResourceAsStream(filename));
        return targetDOM;
    }
}

