/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.metadata.AffiliateMember;
import org.opensaml.saml.saml2.metadata.impl.AffiliateMemberBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AffiliateMemberTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedMemberID;

    public AffiliateMemberTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/AffiliateMember.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedMemberID = "urn:example.org:members:foo";
    }

    @Test
    public void testSingleElementUnmarshall() {
        AffiliateMember member = (AffiliateMember)this.unmarshallElement(this.singleElementFile);
        String memberID = member.getURI();
        Assert.assertEquals((String)memberID, (String)this.expectedMemberID, (String)("Affiliation memeber ID was " + memberID + ", expected " + this.expectedMemberID));
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AffiliateMember", "md");
        AffiliateMember member = (AffiliateMember)this.buildXMLObject(qname);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 1026; ++i) {
            stringBuilder.append(i);
        }
        try {
            member.setURI(stringBuilder.toString());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        member = new AffiliateMemberBuilder().buildObject();
        member.setURI(this.expectedMemberID);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)member);
    }
}

