/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.profile.AbstractSAML2NameIDGenerator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractSAML2NameIDGeneratorTest
extends OpenSAMLInitBaseTestCase {
    private static final String NAME_QUALIFIER = "https://idp.example.org";
    private static final String SP_NAME_QUALIFIER = "https://sp.example.org";

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoFormat() throws ComponentInitializationException {
        MockSAML2NameIDGenerator mock = new MockSAML2NameIDGenerator();
        mock.initialize();
    }

    @Test
    public void testFull() throws ComponentInitializationException, SAMLException {
        MockSAML2NameIDGenerator mock = new MockSAML2NameIDGenerator();
        mock.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        mock.setIdPNameQualifier(NAME_QUALIFIER);
        mock.setSPNameQualifier(SP_NAME_QUALIFIER);
        mock.setSPProvidedId("bar");
        mock.initialize();
        NameID nameId = (NameID)mock.generate(new ProfileRequestContext(), mock.getFormat());
        Assert.assertNotNull((Object)nameId);
        Assert.assertEquals((String)nameId.getValue(), (String)"foo");
        Assert.assertEquals((String)nameId.getSPProvidedID(), (String)"bar");
        Assert.assertEquals((String)nameId.getNameQualifier(), (String)NAME_QUALIFIER);
        Assert.assertEquals((String)nameId.getSPNameQualifier(), (String)SP_NAME_QUALIFIER);
    }

    @Test
    public void testOmitSet() throws ComponentInitializationException, SAMLException {
        MockSAML2NameIDGenerator mock = new MockSAML2NameIDGenerator();
        mock.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        mock.setIdPNameQualifier(NAME_QUALIFIER);
        mock.setSPNameQualifier(SP_NAME_QUALIFIER);
        mock.setOmitQualifiers(true);
        mock.initialize();
        NameID nameId = (NameID)mock.generate(new ProfileRequestContext(), mock.getFormat());
        Assert.assertNotNull((Object)nameId);
        Assert.assertEquals((String)nameId.getValue(), (String)"foo");
        Assert.assertNull((Object)nameId.getNameQualifier());
        Assert.assertNull((Object)nameId.getSPNameQualifier());
    }

    @Test
    public void testOmitUnset() throws ComponentInitializationException, SAMLException {
        MockSAML2NameIDGenerator mock = new MockSAML2NameIDGenerator();
        mock.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        mock.setOmitQualifiers(true);
        mock.initialize();
        NameID nameId = (NameID)mock.generate(new ProfileRequestContext(), mock.getFormat());
        Assert.assertNotNull((Object)nameId);
        Assert.assertEquals((String)nameId.getValue(), (String)"foo");
        Assert.assertNull((Object)nameId.getNameQualifier());
        Assert.assertNull((Object)nameId.getSPNameQualifier());
    }

    @Test
    public void testDefaultQualifier() throws ComponentInitializationException, SAMLException {
        MockSAML2NameIDGenerator mock = new MockSAML2NameIDGenerator();
        mock.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        mock.initialize();
        NameID nameId = (NameID)mock.generate(new ProfileRequestContext(), mock.getFormat());
        Assert.assertNotNull((Object)nameId);
        Assert.assertEquals((String)nameId.getValue(), (String)"foo");
        Assert.assertEquals((String)nameId.getNameQualifier(), (String)NAME_QUALIFIER);
        Assert.assertEquals((String)nameId.getSPNameQualifier(), (String)SP_NAME_QUALIFIER);
    }

    private class MockSAML2NameIDGenerator
    extends AbstractSAML2NameIDGenerator {
        public MockSAML2NameIDGenerator() {
            this.setId("test");
            this.setDefaultIdPNameQualifierLookupStrategy(FunctionSupport.constant((Object)AbstractSAML2NameIDGeneratorTest.NAME_QUALIFIER));
            this.setDefaultSPNameQualifierLookupStrategy(FunctionSupport.constant((Object)AbstractSAML2NameIDGeneratorTest.SP_NAME_QUALIFIER));
        }

        protected String getIdentifier(ProfileRequestContext profileRequestContext) throws SAMLException {
            return "foo";
        }
    }
}

