/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.messaging.context.ChannelBindingsContext;
import org.opensaml.saml.ext.saml2cb.ChannelBindings;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.opensaml.saml.saml2.profile.impl.AddChannelBindingsToAssertions;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddChannelBindingsToAssertionsTest
extends OpenSAMLInitBaseTestCase {
    private ChannelBindingsContext cbc;
    private AddChannelBindingsToAssertions action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        SAMLObjectBuilder cbBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME);
        ChannelBindings cb = (ChannelBindings)cbBuilder.buildObject();
        cb.setType("foo");
        this.cbc = new ChannelBindingsContext();
        this.cbc.getChannelBindings().add(cb);
        this.action = new AddChannelBindingsToAssertions();
        this.action.initialize();
    }

    @Test
    public void testNoResponse() {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        prc.getOutboundMessageContext().addSubcontext((BaseContext)this.cbc);
        this.action.execute(prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoBindings() {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
    }

    @Test
    public void testNoAssertion() {
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)SAML2ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        prc.getOutboundMessageContext().addSubcontext((BaseContext)this.cbc);
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
    }

    @Test
    public void testSingleAssertion() {
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        prc.getOutboundMessageContext().addSubcontext((BaseContext)this.cbc);
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getAdvice());
        Assert.assertEquals((int)assertion.getAdvice().getChildren(ChannelBindings.DEFAULT_ELEMENT_NAME).size(), (int)1);
        Assert.assertEquals((String)((ChannelBindings)assertion.getAdvice().getChildren(ChannelBindings.DEFAULT_ELEMENT_NAME).get(0)).getType(), (String)"foo");
    }

    @Test
    public void testSingleAssertionWithExistingCondition() {
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        SAML2ActionSupport.addAdviceToAssertion((AbstractProfileAction)this.action, (Assertion)assertion);
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        prc.getOutboundMessageContext().addSubcontext((BaseContext)this.cbc);
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)assertion.getAdvice());
        Assert.assertEquals((int)assertion.getAdvice().getChildren(ChannelBindings.DEFAULT_ELEMENT_NAME).size(), (int)1);
        Assert.assertEquals((String)((ChannelBindings)assertion.getAdvice().getChildren(ChannelBindings.DEFAULT_ELEMENT_NAME).get(0)).getType(), (String)"foo");
    }

    @Test
    public void testMultipleAssertion() {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        prc.getOutboundMessageContext().addSubcontext((BaseContext)this.cbc);
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)3);
        for (Assertion assertion : response.getAssertions()) {
            Assert.assertNotNull((Object)assertion.getAdvice());
            Assert.assertEquals((int)assertion.getAdvice().getChildren(ChannelBindings.DEFAULT_ELEMENT_NAME).size(), (int)1);
            Assert.assertEquals((String)((ChannelBindings)assertion.getAdvice().getChildren(ChannelBindings.DEFAULT_ELEMENT_NAME).get(0)).getType(), (String)"foo");
        }
    }
}

