/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.OneTimeUse;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.impl.AddOneTimeUseConditionToAssertions;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddOneTimeUseConditionToAssertionsTest
extends OpenSAMLInitBaseTestCase {
    private AddOneTimeUseConditionToAssertions action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new AddOneTimeUseConditionToAssertions();
        this.action.initialize();
    }

    @Test
    public void testNoResponse() {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoAssertion() {
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)SAML2ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
    }

    @Test
    public void testSingleAssertion() {
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getOneTimeUse());
    }

    @Test
    public void testSingleAssertionWithExistingCondition() {
        SAMLObjectBuilder conditionBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(OneTimeUse.DEFAULT_ELEMENT_NAME);
        OneTimeUse condition = (OneTimeUse)conditionBuilder.buildObject();
        SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsBuilder.buildObject();
        conditions.getConditions().add(condition);
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        assertion.setConditions(conditions);
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getOneTimeUse());
    }

    @Test
    public void testMultipleAssertion() {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)3);
        for (Assertion assertion : response.getAssertions()) {
            Assert.assertNotNull((Object)assertion.getConditions());
            Assert.assertNotNull((Object)assertion.getConditions().getOneTimeUse());
        }
    }
}

