/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import java.util.Set;
import java.util.stream.Collectors;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.ProxyRestriction;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.impl.AddProxyRestrictionToAssertions;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddProxyRestrictionToAssertionsTest
extends OpenSAMLInitBaseTestCase {
    private static final String AUDIENCE1 = "foo";
    private static final String AUDIENCE2 = "foo2";
    private AddProxyRestrictionToAssertions action;

    @BeforeMethod
    public void setUp() {
        this.action = new AddProxyRestrictionToAssertions();
        this.action.setProxyRestrictionLookupStrategy(FunctionSupport.constant((Object)new Pair((Object)1, Set.of(AUDIENCE1, AUDIENCE2))));
    }

    @Test
    public void testNoResponse() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action.initialize();
        this.action.execute(prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoAssertion() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)SAML2ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        this.action.initialize();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
    }

    @Test
    public void testZeroCount() throws ComponentInitializationException {
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.setProxyRestrictionLookupStrategy(FunctionSupport.constant((Object)new Pair((Object)0, Set.of(AUDIENCE1, AUDIENCE2))));
        this.action.initialize();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getProxyRestriction());
        ProxyRestriction proxy = assertion.getConditions().getProxyRestriction();
        Assert.assertEquals((Object)proxy.getProxyCount(), (Object)0);
        Assert.assertTrue((boolean)proxy.getAudiences().isEmpty());
    }

    @Test
    public void testCountOnly() throws ComponentInitializationException {
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.setProxyRestrictionLookupStrategy(FunctionSupport.constant((Object)new Pair((Object)1, null)));
        this.action.initialize();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getProxyRestriction());
        ProxyRestriction proxy = assertion.getConditions().getProxyRestriction();
        Assert.assertEquals((Object)proxy.getProxyCount(), (Object)1);
        Assert.assertTrue((boolean)proxy.getAudiences().isEmpty());
    }

    @Test
    public void testAudiencesOnly() throws ComponentInitializationException {
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.setProxyRestrictionLookupStrategy(FunctionSupport.constant((Object)new Pair(null, Set.of(AUDIENCE1, AUDIENCE2))));
        this.action.initialize();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getProxyRestriction());
        ProxyRestriction proxy = assertion.getConditions().getProxyRestriction();
        Assert.assertNull((Object)proxy.getProxyCount());
        Assert.assertEquals(proxy.getAudiences().stream().map(XSURI::getURI).collect(Collectors.toUnmodifiableSet()), Set.of(AUDIENCE1, AUDIENCE2));
    }

    @Test
    public void testSingleAssertion() throws ComponentInitializationException {
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.initialize();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getProxyRestriction());
        ProxyRestriction proxy = assertion.getConditions().getProxyRestriction();
        Assert.assertEquals((Object)proxy.getProxyCount(), (Object)1);
        Assert.assertEquals(proxy.getAudiences().stream().map(XSURI::getURI).collect(Collectors.toUnmodifiableSet()), Set.of(AUDIENCE1, AUDIENCE2));
    }

    @Test
    public void testSingleAssertionWithExistingCondition() throws ComponentInitializationException {
        SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsBuilder.buildObject();
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        assertion.setConditions(conditions);
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.initialize();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getProxyRestriction());
        ProxyRestriction proxy = assertion.getConditions().getProxyRestriction();
        Assert.assertEquals((Object)proxy.getProxyCount(), (Object)1);
        Assert.assertEquals(proxy.getAudiences().stream().map(XSURI::getURI).collect(Collectors.toUnmodifiableSet()), Set.of(AUDIENCE1, AUDIENCE2));
    }

    @Test
    public void testMultipleAssertion() throws ComponentInitializationException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.initialize();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)3);
        for (Assertion assertion : response.getAssertions()) {
            Assert.assertNotNull((Object)assertion.getConditions());
            Assert.assertNotNull((Object)assertion.getConditions().getProxyRestriction());
            ProxyRestriction proxy = assertion.getConditions().getProxyRestriction();
            Assert.assertEquals((Object)proxy.getProxyCount(), (Object)1);
            Assert.assertEquals(proxy.getAudiences().stream().map(XSURI::getURI).collect(Collectors.toUnmodifiableSet()), Set.of(AUDIENCE1, AUDIENCE2));
        }
    }
}

