/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.saml.saml2.profile.impl.EncryptNameIDs;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestSelfEncryption
extends OpenSAMLInitBaseTestCase {
    private EncryptionParameters encParams;
    private EncryptionParameters encParamsSelf1;
    private EncryptionParameters encParamsSelf2;
    private ProfileRequestContext prc;
    private EncryptNameIDs action;

    @BeforeMethod
    public void setUp() throws NoSuchAlgorithmException, NoSuchProviderException {
        BasicKeyInfoGeneratorFactory generator = new BasicKeyInfoGeneratorFactory();
        generator.setEmitPublicKeyValue(true);
        this.encParams = new EncryptionParameters();
        this.encParams.setDataEncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.encParams.setDataKeyInfoGenerator(generator.newInstance());
        this.encParams.setKeyTransportEncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        this.encParams.setKeyTransportEncryptionCredential(AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (int)1024, (boolean)false));
        this.encParams.setKeyTransportKeyInfoGenerator(generator.newInstance());
        this.encParamsSelf1 = new EncryptionParameters();
        this.encParamsSelf1.setDataEncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.encParamsSelf1.setDataKeyInfoGenerator(generator.newInstance());
        this.encParamsSelf1.setKeyTransportEncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        this.encParamsSelf1.setKeyTransportEncryptionCredential(AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (int)1024, (boolean)false));
        this.encParamsSelf1.setKeyTransportKeyInfoGenerator(generator.newInstance());
        this.encParamsSelf2 = new EncryptionParameters();
        this.encParamsSelf2.setDataEncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.encParamsSelf2.setDataKeyInfoGenerator(generator.newInstance());
        this.encParamsSelf2.setKeyTransportEncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        this.encParamsSelf2.setKeyTransportEncryptionCredential(AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (int)1024, (boolean)false));
        this.encParamsSelf2.setKeyTransportKeyInfoGenerator(generator.newInstance());
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        ((EncryptionContext)this.prc.getOutboundMessageContext().getSubcontext(EncryptionContext.class, true)).setIdentifierEncryptionParameters(this.encParams);
        this.action = new EncryptNameIDs();
    }

    @Test
    public void testSelfEncryption() throws EncryptionException, ComponentInitializationException, MarshallingException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        this.prc.getOutboundMessageContext().setMessage((Object)response);
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        ((Assertion)response.getAssertions().get(0)).setSubject(SAML2ActionTestingSupport.buildSubject((String)"morpheus"));
        this.action.setEncryptToSelf((Predicate)Predicates.alwaysTrue());
        this.action.setEncryptToSelfParametersStrategy(FunctionSupport.constant(List.of(this.encParamsSelf1, this.encParamsSelf2)));
        this.action.setSelfRecipientLookupStrategy(FunctionSupport.constant((Object)"https://idp.example.org"));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNull((Object)((Assertion)response.getAssertions().get(0)).getSubject().getNameID());
        Assert.assertNotNull((Object)((Assertion)response.getAssertions().get(0)).getSubject().getEncryptedID());
        EncryptedID encTarget = ((Assertion)response.getAssertions().get(0)).getSubject().getEncryptedID();
        Assert.assertEquals((String)encTarget.getEncryptedData().getType(), (String)"http://www.w3.org/2001/04/xmlenc#Element", (String)"Type attribute");
        Assert.assertEquals((String)encTarget.getEncryptedData().getEncryptionMethod().getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (String)"Algorithm attribute");
        Assert.assertNotNull((Object)encTarget.getEncryptedData().getKeyInfo(), (String)"KeyInfo");
        Assert.assertEquals((int)encTarget.getEncryptedData().getKeyInfo().getEncryptedKeys().size(), (int)3, (String)"Number of EncryptedKeys");
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)encTarget.getEncryptedData().getID()), (String)"EncryptedData ID attribute was empty");
    }

    @Test
    public void testFailureNoSelfEncryptionCreds() throws EncryptionException, ComponentInitializationException, MarshallingException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        this.prc.getOutboundMessageContext().setMessage((Object)response);
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        ((Assertion)response.getAssertions().get(0)).setSubject(SAML2ActionTestingSupport.buildSubject((String)"morpheus"));
        this.action.setEncryptToSelf((Predicate)Predicates.alwaysTrue());
        this.action.setEncryptToSelfParametersStrategy(FunctionSupport.constant(Collections.emptyList()));
        this.action.setSelfRecipientLookupStrategy(FunctionSupport.constant((Object)"https://idp.example.org"));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"UnableToEncrypt");
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)((Assertion)response.getAssertions().get(0)).getSubject().getNameID());
        Assert.assertNull((Object)((Assertion)response.getAssertions().get(0)).getSubject().getEncryptedID());
    }
}

