/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.security.impl;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.collection.Pair;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.security.impl.InlineSelfEncryptionParametersStrategy;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.EncryptionParametersResolver;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.impl.BasicEncryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicEncryptionParametersResolver;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InlineSelfEncryptionParametersStrategyTest
extends OpenSAMLInitBaseTestCase {
    private Credential cred1;
    private Credential cred2;
    private List<Credential> resolverCreds;
    private CollectionCredentialResolver credResolver;
    private EncryptionParametersResolver paramsResolver;
    private ProfileRequestContext prc;

    @BeforeClass
    public void classSetUp() throws NoSuchAlgorithmException, NoSuchProviderException {
        this.cred1 = AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (int)1024, (boolean)true);
        this.cred2 = AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (int)1024, (boolean)true);
        this.paramsResolver = new BasicEncryptionParametersResolver();
    }

    @BeforeMethod
    public void setUp() {
        this.resolverCreds = new ArrayList<Credential>();
        this.credResolver = new CollectionCredentialResolver(this.resolverCreds);
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
    }

    @Test
    public void testNoCreds() {
        InlineSelfEncryptionParametersStrategy strategy = new InlineSelfEncryptionParametersStrategy((CredentialResolver)this.credResolver, this.paramsResolver);
        List encParameters = strategy.apply(new Pair((Object)this.prc, null));
        Assert.assertNotNull((Object)encParameters);
        Assert.assertTrue((boolean)encParameters.isEmpty());
    }

    @Test
    public void testSingleCred() {
        this.resolverCreds.add(this.cred1);
        InlineSelfEncryptionParametersStrategy strategy = new InlineSelfEncryptionParametersStrategy((CredentialResolver)this.credResolver, this.paramsResolver);
        List encParameters = strategy.apply(new Pair((Object)this.prc, null));
        Assert.assertNotNull((Object)encParameters);
        Assert.assertEquals((int)encParameters.size(), (int)1);
        Assert.assertSame((Object)((EncryptionParameters)encParameters.get(0)).getKeyTransportEncryptionCredential(), (Object)this.cred1);
        Assert.assertEquals((String)((EncryptionParameters)encParameters.get(0)).getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        Assert.assertEquals((String)((EncryptionParameters)encParameters.get(0)).getRSAOAEPParameters().getDigestMethod(), (String)"http://www.w3.org/2000/09/xmldsig#sha1");
        Assert.assertEquals((String)((EncryptionParameters)encParameters.get(0)).getRSAOAEPParameters().getMaskGenerationFunction(), (String)"http://www.w3.org/2009/xmlenc11#mgf1sha1");
    }

    @Test
    public void testMultipleCreds() {
        this.resolverCreds.add(this.cred1);
        this.resolverCreds.add(this.cred2);
        InlineSelfEncryptionParametersStrategy strategy = new InlineSelfEncryptionParametersStrategy((CredentialResolver)this.credResolver, this.paramsResolver);
        List encParameters = strategy.apply(new Pair((Object)this.prc, null));
        Assert.assertNotNull((Object)encParameters);
        Assert.assertEquals((int)encParameters.size(), (int)2);
        Assert.assertSame((Object)((EncryptionParameters)encParameters.get(0)).getKeyTransportEncryptionCredential(), (Object)this.cred1);
        Assert.assertEquals((String)((EncryptionParameters)encParameters.get(0)).getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        Assert.assertEquals((String)((EncryptionParameters)encParameters.get(0)).getRSAOAEPParameters().getDigestMethod(), (String)"http://www.w3.org/2000/09/xmldsig#sha1");
        Assert.assertSame((Object)((EncryptionParameters)encParameters.get(1)).getKeyTransportEncryptionCredential(), (Object)this.cred2);
        Assert.assertEquals((String)((EncryptionParameters)encParameters.get(1)).getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        Assert.assertEquals((String)((EncryptionParameters)encParameters.get(1)).getRSAOAEPParameters().getDigestMethod(), (String)"http://www.w3.org/2000/09/xmldsig#sha1");
    }

    @Test
    public void testConfigLookup() {
        this.resolverCreds.add(this.cred1);
        Function<ProfileRequestContext, List<EncryptionConfiguration>> configStrategy = new Function<ProfileRequestContext, List<EncryptionConfiguration>>(){

            @Override
            public List<EncryptionConfiguration> apply(@Nullable ProfileRequestContext input) {
                BasicEncryptionConfiguration selfConfig = new BasicEncryptionConfiguration();
                RSAOAEPParameters rsaParams = new RSAOAEPParameters();
                rsaParams.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
                selfConfig.setRSAOAEPParameters(rsaParams);
                selfConfig.setRSAOAEPParametersMerge(true);
                return List.of(selfConfig, SecurityConfigurationSupport.getGlobalEncryptionConfiguration());
            }
        };
        InlineSelfEncryptionParametersStrategy strategy = new InlineSelfEncryptionParametersStrategy((CredentialResolver)this.credResolver, this.paramsResolver, (Function)configStrategy);
        List encParameters = strategy.apply(new Pair((Object)this.prc, null));
        Assert.assertNotNull((Object)encParameters);
        Assert.assertEquals((int)encParameters.size(), (int)1);
        Assert.assertSame((Object)((EncryptionParameters)encParameters.get(0)).getKeyTransportEncryptionCredential(), (Object)this.cred1);
        Assert.assertEquals((String)((EncryptionParameters)encParameters.get(0)).getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        Assert.assertEquals((String)((EncryptionParameters)encParameters.get(0)).getRSAOAEPParameters().getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
    }
}

