/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto.dh;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPublicKeySpec;
import org.opensaml.security.crypto.dh.BaseDHTest;
import org.opensaml.security.crypto.dh.DHSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DHSupportTest
extends BaseDHTest {
    @Test(dataProvider="dhKeySizes")
    public void generateCompatibleKeyPair(int keySize) throws Exception {
        KeyPairGenerator kpGenerator = KeyPairGenerator.getInstance("DiffieHellman");
        kpGenerator.initialize(keySize);
        KeyPair origKeyPair = kpGenerator.generateKeyPair();
        Assert.assertNotNull((Object)origKeyPair);
        Assert.assertTrue((boolean)DHPublicKey.class.isInstance(origKeyPair.getPublic()));
        DHPublicKey origPublicKey = (DHPublicKey)DHPublicKey.class.cast(origKeyPair.getPublic());
        KeyPair generatedKeyPair = DHSupport.generateCompatibleKeyPair((DHPublicKey)origPublicKey, null);
        Assert.assertNotNull((Object)generatedKeyPair);
        Assert.assertTrue((boolean)DHPublicKey.class.isInstance(generatedKeyPair.getPublic()));
        Assert.assertTrue((boolean)DHPrivateKey.class.isInstance(generatedKeyPair.getPrivate()));
    }

    @Test(dataProvider="dhKeySizes")
    public void performKeyAgreement(int keySize) throws Exception {
        KeyPairGenerator kpGenerator = KeyPairGenerator.getInstance("DiffieHellman");
        kpGenerator.initialize(keySize);
        KeyPair publicKeyPair = kpGenerator.generateKeyPair();
        DHPublicKey publicKey = (DHPublicKey)DHPublicKey.class.cast(publicKeyPair.getPublic());
        KeyPair privateKeyPair = DHSupport.generateCompatibleKeyPair((DHPublicKey)publicKey, null);
        DHPrivateKey privateKey = (DHPrivateKey)DHPrivateKey.class.cast(privateKeyPair.getPrivate());
        byte[] secret = DHSupport.performKeyAgreement((DHPublicKey)publicKey, (DHPrivateKey)privateKey, null);
        Assert.assertNotNull((Object)secret);
    }

    @Test(dataProvider="dhKeySizes")
    public void getPrimeQDomainParameter(int keySize) throws Exception {
        KeyPairGenerator kpGenerator = KeyPairGenerator.getInstance("DiffieHellman");
        kpGenerator.initialize(keySize);
        KeyPair publicKeyPair = kpGenerator.generateKeyPair();
        DHPublicKey publicKey1 = (DHPublicKey)DHPublicKey.class.cast(publicKeyPair.getPublic());
        BigInteger q1 = DHSupport.getPrimeQDomainParameter((DHPublicKey)publicKey1);
        Assert.assertNotNull((Object)q1);
        DHPublicKeySpec dhPubSpec = new DHPublicKeySpec(publicKey1.getY(), publicKey1.getParams().getP(), publicKey1.getParams().getG());
        KeyFactory keyFactory = KeyFactory.getInstance("DiffieHellman");
        DHPublicKey publicKey2 = (DHPublicKey)DHPublicKey.class.cast(keyFactory.generatePublic(dhPubSpec));
        Assert.assertEquals((Object)publicKey2, (Object)publicKey2);
        KeyPairGenerator kpGenerator2 = KeyPairGenerator.getInstance("DiffieHellman");
        kpGenerator2.initialize(publicKey2.getParams());
        KeyPair compatKeyPair = kpGenerator.generateKeyPair();
        DHPublicKey publicKey3 = (DHPublicKey)DHPublicKey.class.cast(compatKeyPair.getPublic());
        BigInteger q3 = DHSupport.getPrimeQDomainParameter((DHPublicKey)publicKey3);
        Assert.assertNotNull((Object)q3);
        Assert.assertEquals((Object)q3, (Object)q1);
    }
}

