/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto.ec;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Set;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.crypto.ec.BaseNamedCurveTest;
import org.opensaml.security.crypto.ec.ECSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ECSupportTest
extends BaseNamedCurveTest {
    @Test(dataProvider="namedCurves")
    public void generateCompatibleKeyPair(String namedCurve) throws Exception {
        KeyPairGenerator kpGenerator = KeyPairGenerator.getInstance("EC");
        kpGenerator.initialize(new ECGenParameterSpec(namedCurve));
        KeyPair origKeyPair = kpGenerator.generateKeyPair();
        Assert.assertNotNull((Object)origKeyPair);
        Assert.assertTrue((boolean)ECPublicKey.class.isInstance(origKeyPair.getPublic()));
        ECPublicKey origPublicKey = (ECPublicKey)ECPublicKey.class.cast(origKeyPair.getPublic());
        KeyPair generatedKeyPair = ECSupport.generateCompatibleKeyPair((ECPublicKey)origPublicKey, null);
        Assert.assertNotNull((Object)generatedKeyPair);
        Assert.assertTrue((boolean)ECPublicKey.class.isInstance(generatedKeyPair.getPublic()));
        Assert.assertTrue((boolean)ECPrivateKey.class.isInstance(generatedKeyPair.getPrivate()));
    }

    @Test(dataProvider="namedCurves")
    public void performKeyAgreement(String namedCurve) throws Exception {
        KeyPairGenerator kpGenerator = KeyPairGenerator.getInstance("EC");
        kpGenerator.initialize(new ECGenParameterSpec(namedCurve));
        KeyPair publicKeyPair = kpGenerator.generateKeyPair();
        ECPublicKey publicKey = (ECPublicKey)ECPublicKey.class.cast(publicKeyPair.getPublic());
        KeyPair privateKeyPair = ECSupport.generateCompatibleKeyPair((ECPublicKey)publicKey, null);
        ECPrivateKey privateKey = (ECPrivateKey)ECPrivateKey.class.cast(privateKeyPair.getPrivate());
        byte[] secret = ECSupport.performKeyAgreement((ECPublicKey)publicKey, (ECPrivateKey)privateKey, null);
        Assert.assertNotNull((Object)secret);
    }

    @Test(dataProvider="namedCurves")
    public void convertParameterSpec(String namedCurve) throws Exception {
        ECParameterSpec control = ((ECPublicKey)ECPublicKey.class.cast(KeySupport.generateKeyPair((String)"EC", (AlgorithmParameterSpec)new ECGenParameterSpec(namedCurve), null).getPublic())).getParams();
        ECParameterSpec target = ECSupport.convert((ECNamedCurveParameterSpec)ECNamedCurveTable.getParameterSpec((String)namedCurve));
        Assert.assertNotNull((Object)target);
        Assert.assertNotSame((Object)target, (Object)control);
        Assert.assertEquals((int)target.getCurve().getField().getFieldSize(), (int)control.getCurve().getField().getFieldSize());
        Assert.assertEquals((Object)target.getCurve(), (Object)control.getCurve());
        Assert.assertEquals((Object)target.getGenerator(), (Object)control.getGenerator());
        Assert.assertEquals((Object)target.getOrder(), (Object)control.getOrder());
        Assert.assertEquals((int)target.getCofactor(), (int)control.getCofactor());
    }

    @Test(dataProvider="namedCurves")
    public void encodeAndDecodeECPoint(String namedCurve) throws Exception {
        ECParameterSpec spec = ((ECPublicKey)ECPublicKey.class.cast(KeySupport.generateKeyPair((String)"EC", (AlgorithmParameterSpec)new ECGenParameterSpec(namedCurve), null).getPublic())).getParams();
        int fieldSizeBits = spec.getCurve().getField().getFieldSize();
        int fieldSizeBytes = fieldSizeBits % 8 == 0 ? fieldSizeBits / 8 : fieldSizeBits / 8 + 1;
        byte[] encoded = ECSupport.encodeECPointUncompressed((ECPoint)spec.getGenerator(), (EllipticCurve)spec.getCurve());
        Assert.assertNotNull((Object)encoded);
        Assert.assertEquals((int)encoded.length, (int)(fieldSizeBytes * 2 + 1));
        Assert.assertEquals((int)encoded[0], (int)4);
        Assert.assertEquals((Object)new BigInteger(1, encoded, 1, fieldSizeBytes), (Object)spec.getGenerator().getAffineX());
        Assert.assertEquals((Object)new BigInteger(1, encoded, fieldSizeBytes + 1, fieldSizeBytes), (Object)spec.getGenerator().getAffineY());
        ECPoint decoded = ECSupport.decodeECPoint((byte[])encoded, (EllipticCurve)spec.getCurve());
        Assert.assertNotNull((Object)decoded);
        Assert.assertEquals((Object)decoded, (Object)spec.getGenerator());
    }

    @Test
    public void getCurvesFromBouncyCastle() {
        Set curves = ECSupport.getCurvesFromBouncyCastle();
        Assert.assertNotNull((Object)curves);
        Assert.assertFalse((boolean)curves.isEmpty());
    }
}

