/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto.ec;

import java.security.spec.ECParameterSpec;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.provider.ThreadLocalConfigurationPropertiesHolder;
import org.opensaml.security.config.GlobalNamedCurveRegistryInitializer;
import org.opensaml.security.crypto.ec.BaseNamedCurveTest;
import org.opensaml.security.crypto.ec.ECSupport;
import org.opensaml.security.crypto.ec.NamedCurve;
import org.opensaml.security.crypto.ec.NamedCurveRegistry;
import org.opensaml.security.crypto.ec.curves.Secp256r1;
import org.opensaml.security.crypto.ec.curves.Secp384r1;
import org.opensaml.security.crypto.ec.curves.Secp521r1;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NamedCurveRegistryTest
extends BaseNamedCurveTest {
    @Test
    public void basicOps() throws Exception {
        Secp256r1 secp256r1 = new Secp256r1();
        secp256r1.initialize();
        Secp384r1 secp384r1 = new Secp384r1();
        secp384r1.initialize();
        Secp521r1 secp521r1 = new Secp521r1();
        secp521r1.initialize();
        ECParameterSpec secp256r1ParamSpec = ECSupport.convert((ECNamedCurveParameterSpec)ECNamedCurveTable.getParameterSpec((String)secp256r1.getObjectIdentifier()));
        ECParameterSpec secp384r1ParamSpec = ECSupport.convert((ECNamedCurveParameterSpec)ECNamedCurveTable.getParameterSpec((String)secp384r1.getObjectIdentifier()));
        ECParameterSpec secp521r1ParamSpec = ECSupport.convert((ECNamedCurveParameterSpec)ECNamedCurveTable.getParameterSpec((String)secp521r1.getObjectIdentifier()));
        Assert.assertNotNull((Object)secp256r1ParamSpec);
        Assert.assertNotNull((Object)secp384r1ParamSpec);
        Assert.assertNotNull((Object)secp521r1ParamSpec);
        NamedCurveRegistry registry = new NamedCurveRegistry();
        Assert.assertTrue((boolean)registry.getRegisteredCurves().isEmpty());
        Assert.assertNull((Object)registry.getByName(secp256r1.getName()));
        Assert.assertNull((Object)registry.getByOID(secp256r1.getObjectIdentifier()));
        Assert.assertNull((Object)registry.getByURI(secp256r1.getURI()));
        Assert.assertNull((Object)registry.getByParameterSpec(secp256r1.getParameterSpec()));
        Assert.assertNull((Object)registry.getByParameterSpec(secp256r1ParamSpec));
        registry.register((NamedCurve)secp256r1);
        Assert.assertEquals((int)registry.getRegisteredCurves().size(), (int)1);
        Assert.assertEquals(registry.getRegisteredCurves().stream().map(NamedCurve::getName).collect(Collectors.toSet()), Set.of("secp256r1"));
        Assert.assertTrue((boolean)registry.getRegisteredCurves().contains(secp256r1));
        Assert.assertSame((Object)registry.getByName(secp256r1.getName()), (Object)secp256r1);
        Assert.assertSame((Object)registry.getByOID(secp256r1.getObjectIdentifier()), (Object)secp256r1);
        Assert.assertSame((Object)registry.getByURI(secp256r1.getURI()), (Object)secp256r1);
        Assert.assertSame((Object)registry.getByParameterSpec(secp256r1.getParameterSpec()), (Object)secp256r1);
        Assert.assertSame((Object)registry.getByParameterSpec(secp256r1ParamSpec), (Object)secp256r1);
        secp256r1 = new Secp256r1();
        secp256r1.initialize();
        registry.register((NamedCurve)secp256r1);
        Assert.assertEquals((int)registry.getRegisteredCurves().size(), (int)1);
        Assert.assertEquals(registry.getRegisteredCurves().stream().map(NamedCurve::getName).collect(Collectors.toSet()), Set.of("secp256r1"));
        Assert.assertTrue((boolean)registry.getRegisteredCurves().contains(secp256r1));
        registry.register((NamedCurve)secp384r1);
        registry.register((NamedCurve)secp521r1);
        Assert.assertEquals((int)registry.getRegisteredCurves().size(), (int)3);
        Assert.assertEquals(registry.getRegisteredCurves().stream().map(NamedCurve::getName).collect(Collectors.toSet()), Set.of("secp256r1", "secp384r1", "secp521r1"));
        Assert.assertTrue((boolean)registry.getRegisteredCurves().contains(secp256r1));
        Assert.assertTrue((boolean)registry.getRegisteredCurves().contains(secp384r1));
        Assert.assertTrue((boolean)registry.getRegisteredCurves().contains(secp521r1));
        Assert.assertSame((Object)registry.getByName(secp384r1.getName()), (Object)secp384r1);
        Assert.assertSame((Object)registry.getByOID(secp384r1.getObjectIdentifier()), (Object)secp384r1);
        Assert.assertSame((Object)registry.getByURI(secp384r1.getURI()), (Object)secp384r1);
        Assert.assertSame((Object)registry.getByParameterSpec(secp384r1.getParameterSpec()), (Object)secp384r1);
        Assert.assertSame((Object)registry.getByParameterSpec(secp384r1ParamSpec), (Object)secp384r1);
        Assert.assertSame((Object)registry.getByName(secp521r1.getName()), (Object)secp521r1);
        Assert.assertSame((Object)registry.getByOID(secp521r1.getObjectIdentifier()), (Object)secp521r1);
        Assert.assertSame((Object)registry.getByURI(secp521r1.getURI()), (Object)secp521r1);
        Assert.assertSame((Object)registry.getByParameterSpec(secp521r1.getParameterSpec()), (Object)secp521r1);
        Assert.assertSame((Object)registry.getByParameterSpec(secp521r1ParamSpec), (Object)secp521r1);
        registry.deregister((NamedCurve)secp521r1);
        Assert.assertEquals((int)registry.getRegisteredCurves().size(), (int)2);
        Assert.assertEquals(registry.getRegisteredCurves().stream().map(NamedCurve::getName).collect(Collectors.toSet()), Set.of("secp256r1", "secp384r1"));
        Assert.assertTrue((boolean)registry.getRegisteredCurves().contains(secp256r1));
        Assert.assertTrue((boolean)registry.getRegisteredCurves().contains(secp384r1));
        Assert.assertFalse((boolean)registry.getRegisteredCurves().contains(secp521r1));
        Assert.assertNull((Object)registry.getByName(secp521r1.getName()));
        Assert.assertNull((Object)registry.getByOID(secp521r1.getObjectIdentifier()));
        Assert.assertNull((Object)registry.getByURI(secp521r1.getURI()));
        Assert.assertNull((Object)registry.getByParameterSpec(secp521r1.getParameterSpec()));
        Assert.assertNull((Object)registry.getByParameterSpec(secp521r1ParamSpec));
        registry.deregisterByName(secp256r1.getName());
        registry.deregisterByOID(secp384r1.getObjectIdentifier());
        Assert.assertTrue((boolean)registry.getRegisteredCurves().isEmpty());
        registry.register((NamedCurve)secp256r1);
        Assert.assertEquals((int)registry.getRegisteredCurves().size(), (int)1);
        Assert.assertTrue((boolean)registry.getRegisteredCurves().contains(secp256r1));
        registry.deregisterByURI(secp256r1.getURI());
        Assert.assertTrue((boolean)registry.getRegisteredCurves().isEmpty());
        Assert.assertFalse((boolean)registry.getRegisteredCurves().contains(secp256r1));
        registry.register((NamedCurve)secp256r1);
        Assert.assertEquals((int)registry.getRegisteredCurves().size(), (int)1);
        Assert.assertTrue((boolean)registry.getRegisteredCurves().contains(secp256r1));
        registry.deregisterByParameterSpec(secp256r1ParamSpec);
        Assert.assertTrue((boolean)registry.getRegisteredCurves().isEmpty());
        Assert.assertFalse((boolean)registry.getRegisteredCurves().contains(secp256r1));
        registry.register((NamedCurve)secp256r1);
        registry.register((NamedCurve)secp384r1);
        Assert.assertEquals((int)registry.getRegisteredCurves().size(), (int)2);
        Assert.assertTrue((boolean)registry.getRegisteredCurves().contains(secp256r1));
        Assert.assertTrue((boolean)registry.getRegisteredCurves().contains(secp384r1));
        registry.clear();
        Assert.assertTrue((boolean)registry.getRegisteredCurves().isEmpty());
    }

    @Test
    public void globalRegistry() {
        NamedCurveRegistry registry = ECSupport.getGlobalNamedCurveRegistry();
        Assert.assertNotNull((Object)registry);
        Assert.assertTrue((registry.getRegisteredCurves().size() >= 3 ? 1 : 0) != 0);
        Set curveNames = registry.getRegisteredCurves().stream().map(NamedCurve::getName).collect(Collectors.toSet());
        Assert.assertTrue((boolean)curveNames.contains("secp256r1"));
        Assert.assertTrue((boolean)curveNames.contains("secp384r1"));
        Assert.assertTrue((boolean)curveNames.contains("secp521r1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void registerBouncyCastleCurves() throws Exception {
        String propName = "opensaml.config.ec.registerBouncyCastleCurves";
        NamedCurveRegistry origRegistry = ECSupport.getGlobalNamedCurveRegistry();
        try {
            Properties props = new Properties();
            props.setProperty(propName, "true");
            ThreadLocalConfigurationPropertiesHolder.setProperties((Properties)props);
            new GlobalNamedCurveRegistryInitializer().init();
            NamedCurveRegistry bcRegistry = ECSupport.getGlobalNamedCurveRegistry();
            Assert.assertNotSame((Object)bcRegistry, (Object)origRegistry);
            Set origCurves = origRegistry.getRegisteredCurves();
            Set bcCurves = bcRegistry.getRegisteredCurves();
            Assert.assertTrue((bcCurves.size() > origCurves.size() ? 1 : 0) != 0);
            Set origOIDs = origCurves.stream().map(NamedCurve::getObjectIdentifier).collect(Collectors.toSet());
            Set bcOIDs = bcCurves.stream().map(NamedCurve::getObjectIdentifier).collect(Collectors.toSet());
            Assert.assertTrue((boolean)bcOIDs.containsAll(origOIDs));
        }
        finally {
            ThreadLocalConfigurationPropertiesHolder.clear();
            ConfigurationService.register(NamedCurveRegistry.class, (Object)origRegistry);
        }
    }
}

