/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto.ec.curves;

import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Set;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.crypto.ec.BaseNamedCurveTest;
import org.opensaml.security.crypto.ec.ECSupport;
import org.opensaml.security.crypto.ec.EnhancedECParameterSpec;
import org.opensaml.security.crypto.ec.NamedCurve;
import org.opensaml.security.crypto.ec.NamedCurveRegistry;
import org.opensaml.security.crypto.ec.curves.AbstractNamedCurve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NamedCurvesTest
extends BaseNamedCurveTest {
    private Logger log = LoggerFactory.getLogger(NamedCurvesTest.class);

    @Test(dataProvider="namedCurves")
    public void globalRegistryCurves(String namedCurve) throws Exception {
        NamedCurveRegistry registry = ECSupport.getGlobalNamedCurveRegistry();
        Assert.assertNotNull((Object)registry);
        ECParameterSpec bcSpec = ECSupport.convert((ECNamedCurveParameterSpec)ECNamedCurveTable.getParameterSpec((String)namedCurve));
        Assert.assertNotNull((Object)bcSpec);
        Assert.assertNotNull((Object)registry.getByName(namedCurve));
        Assert.assertEquals((String)registry.getByName(namedCurve).getName(), (String)namedCurve);
        Assert.assertNotNull((Object)registry.getByParameterSpec(bcSpec));
        Assert.assertEquals((Object)new EnhancedECParameterSpec(registry.getByParameterSpec(bcSpec).getParameterSpec()), (Object)new EnhancedECParameterSpec(bcSpec));
        NamedCurve curve = registry.getByName(namedCurve);
        if (AbstractNamedCurve.class.isInstance(curve)) {
            ECParameterSpec curveSpec = ((AbstractNamedCurve)AbstractNamedCurve.class.cast(curve)).buildParameterSpec();
            Assert.assertNotNull((Object)curveSpec);
            ECParameterSpec jcaSpec = ((ECPublicKey)ECPublicKey.class.cast(KeySupport.generateKeyPair((String)"EC", (AlgorithmParameterSpec)new ECGenParameterSpec(namedCurve), null).getPublic())).getParams();
            Assert.assertNotNull((Object)jcaSpec);
            Assert.assertEquals((Object)new EnhancedECParameterSpec(curveSpec), (Object)new EnhancedECParameterSpec(jcaSpec));
            Assert.assertEquals((Object)new EnhancedECParameterSpec(curveSpec), (Object)new EnhancedECParameterSpec(bcSpec));
        }
    }

    @Test
    public void sanityCheckOIDAndNameAndParams() throws Exception {
        NamedCurveRegistry registry = ECSupport.getGlobalNamedCurveRegistry();
        Assert.assertNotNull((Object)registry);
        Set registeredCurves = registry.getRegisteredCurves();
        for (NamedCurve curve : registeredCurves) {
            this.log.debug("Testing OID and name for curve: impl {}", (Object)curve.getClass().getName());
            ECParameterSpec specByOID = ECSupport.convert((ECNamedCurveParameterSpec)ECNamedCurveTable.getParameterSpec((String)curve.getObjectIdentifier()));
            Assert.assertNotNull((Object)specByOID);
            ECParameterSpec specByName = ECSupport.convert((ECNamedCurveParameterSpec)ECNamedCurveTable.getParameterSpec((String)this.mapBCCurveName(curve.getName())));
            Assert.assertNotNull((Object)specByName);
            Assert.assertEquals((Object)new EnhancedECParameterSpec(specByOID), (Object)new EnhancedECParameterSpec(specByName));
            Assert.assertEquals((Object)new EnhancedECParameterSpec(curve.getParameterSpec()), (Object)new EnhancedECParameterSpec(specByOID));
        }
    }

    private String mapBCCurveName(String standardName) {
        if (standardName.startsWith("X9.62 ")) {
            return standardName.substring(6);
        }
        return standardName;
    }
}

