/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient;

import java.io.File;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.TrustedNamesCriterion;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class HttpClientSecuritySupportTest {
    private X509Certificate cert;
    private String certDERPath = "/data/certificate.der";

    @BeforeClass
    public void generatedTestData() throws NoSuchAlgorithmException, NoSuchProviderException, CertificateException, URISyntaxException {
        this.cert = X509Support.decodeCertificate((File)new File(HttpClientSecuritySupportTest.class.getResource(this.certDERPath).toURI()));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testMarshalSecurityParametersNullContext() {
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        HttpClientSecuritySupport.marshalSecurityParameters(null, (HttpClientSecurityParameters)params, (boolean)false);
    }

    @Test
    public void testMarshalNullSecurityParameters() {
        HttpClientContext context = HttpClientContext.create();
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)context, null, (boolean)false);
        Assert.assertNull((Object)context.getCredentialsProvider());
        Assert.assertNull((Object)context.getAttribute("opensaml.TrustEngine"));
        Assert.assertNull((Object)context.getAttribute("opensaml.CriteriaSet"));
        Assert.assertNull((Object)context.getAttribute("javasupport.TLSProtocols"));
        Assert.assertNull((Object)context.getAttribute("javasupport.TLSCipherSuites"));
        Assert.assertNull((Object)context.getAttribute("opensaml.ClientTLSCredential"));
        Assert.assertNull((Object)context.getAttribute("javasupport.HostnameVerifier"));
        Assert.assertNull((Object)context.getAttribute("opensaml.ServerTLSFailureIsFatal"));
    }

    @Test
    public void testMarshalSecurityParametersEmptyContext() {
        HttpClientContext context = HttpClientContext.create();
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        params.setTLSTrustEngine((TrustEngine)new MockTrustEngine());
        params.setTLSCriteriaSet(new CriteriaSet());
        params.setTLSProtocols(Collections.singletonList("foo"));
        params.setTLSCipherSuites(Collections.singletonList("foo"));
        params.setClientTLSCredential((X509Credential)new BasicX509Credential(this.cert));
        params.setHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier());
        params.setServerTLSFailureFatal(Boolean.TRUE);
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)context, (HttpClientSecurityParameters)params, (boolean)false);
        Assert.assertSame((Object)context.getCredentialsProvider(), (Object)params.getCredentialsProvider());
        Assert.assertSame((Object)context.getAttribute("opensaml.TrustEngine"), (Object)params.getTLSTrustEngine());
        Assert.assertSame((Object)context.getAttribute("opensaml.CriteriaSet"), (Object)params.getTLSCriteriaSet());
        Assert.assertSame((Object)context.getAttribute("javasupport.TLSProtocols"), (Object)params.getTLSProtocols());
        Assert.assertSame((Object)context.getAttribute("javasupport.TLSCipherSuites"), (Object)params.getTLSCipherSuites());
        Assert.assertSame((Object)context.getAttribute("opensaml.ClientTLSCredential"), (Object)params.getClientTLSCredential());
        Assert.assertSame((Object)context.getAttribute("javasupport.HostnameVerifier"), (Object)params.getHostnameVerifier());
        Assert.assertTrue((boolean)((Boolean)context.getAttribute("opensaml.ServerTLSFailureIsFatal")));
    }

    @Test
    public void testMarshalSecurityParametersWithReplacement() {
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        context.setAttribute("opensaml.TrustEngine", (Object)new MockTrustEngine());
        context.setAttribute("opensaml.CriteriaSet", (Object)new CriteriaSet());
        context.setAttribute("javasupport.TLSProtocols", Collections.singletonList("foo"));
        context.setAttribute("javasupport.TLSCipherSuites", Collections.singletonList("foo"));
        context.setAttribute("opensaml.ClientTLSCredential", (Object)new BasicX509Credential(this.cert));
        context.setAttribute("javasupport.HostnameVerifier", (Object)new DefaultHostnameVerifier());
        context.setAttribute("opensaml.ServerTLSFailureIsFatal", (Object)Boolean.FALSE);
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        params.setTLSTrustEngine((TrustEngine)new MockTrustEngine());
        params.setTLSCriteriaSet(new CriteriaSet());
        params.setTLSProtocols(Collections.singletonList("foo"));
        params.setTLSCipherSuites(Collections.singletonList("foo"));
        params.setClientTLSCredential((X509Credential)new BasicX509Credential(this.cert));
        params.setHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier());
        params.setServerTLSFailureFatal(Boolean.TRUE);
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)context, (HttpClientSecurityParameters)params, (boolean)true);
        Assert.assertSame((Object)context.getCredentialsProvider(), (Object)params.getCredentialsProvider());
        Assert.assertSame((Object)context.getAttribute("opensaml.TrustEngine"), (Object)params.getTLSTrustEngine());
        Assert.assertSame((Object)context.getAttribute("opensaml.CriteriaSet"), (Object)params.getTLSCriteriaSet());
        Assert.assertSame((Object)context.getAttribute("javasupport.TLSProtocols"), (Object)params.getTLSProtocols());
        Assert.assertSame((Object)context.getAttribute("javasupport.TLSCipherSuites"), (Object)params.getTLSCipherSuites());
        Assert.assertSame((Object)context.getAttribute("opensaml.ClientTLSCredential"), (Object)params.getClientTLSCredential());
        Assert.assertSame((Object)context.getAttribute("javasupport.HostnameVerifier"), (Object)params.getHostnameVerifier());
        Assert.assertTrue((boolean)((Boolean)context.getAttribute("opensaml.ServerTLSFailureIsFatal")));
    }

    @Test
    public void testMarshalSecurityParametersWithoutReplacement() {
        HttpClientContext context = HttpClientContext.create();
        BasicCredentialsProvider credProvider = new BasicCredentialsProvider();
        MockTrustEngine trustEngine = new MockTrustEngine();
        CriteriaSet criteriaSet = new CriteriaSet();
        List<String> protocols = Collections.singletonList("foo");
        List<String> cipherSuites = Collections.singletonList("foo");
        BasicX509Credential clientTLSCred = new BasicX509Credential(this.cert);
        DefaultHostnameVerifier verifier = new DefaultHostnameVerifier();
        context.setCredentialsProvider((CredentialsProvider)credProvider);
        context.setAttribute("opensaml.TrustEngine", (Object)trustEngine);
        context.setAttribute("opensaml.CriteriaSet", (Object)criteriaSet);
        context.setAttribute("javasupport.TLSProtocols", protocols);
        context.setAttribute("javasupport.TLSCipherSuites", cipherSuites);
        context.setAttribute("opensaml.ClientTLSCredential", (Object)clientTLSCred);
        context.setAttribute("javasupport.HostnameVerifier", (Object)verifier);
        context.setAttribute("opensaml.ServerTLSFailureIsFatal", (Object)Boolean.FALSE);
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        params.setTLSTrustEngine((TrustEngine)new MockTrustEngine());
        params.setTLSCriteriaSet(new CriteriaSet());
        params.setTLSProtocols(Collections.singletonList("foo"));
        params.setTLSCipherSuites(Collections.singletonList("foo"));
        params.setClientTLSCredential((X509Credential)new BasicX509Credential(this.cert));
        params.setHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier());
        params.setServerTLSFailureFatal(Boolean.TRUE);
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)context, (HttpClientSecurityParameters)params, (boolean)false);
        Assert.assertSame((Object)context.getCredentialsProvider(), (Object)credProvider);
        Assert.assertSame((Object)context.getAttribute("opensaml.TrustEngine"), (Object)trustEngine);
        Assert.assertSame((Object)context.getAttribute("opensaml.CriteriaSet"), (Object)criteriaSet);
        Assert.assertSame((Object)context.getAttribute("javasupport.TLSProtocols"), protocols);
        Assert.assertSame((Object)context.getAttribute("javasupport.TLSCipherSuites"), cipherSuites);
        Assert.assertSame((Object)context.getAttribute("opensaml.ClientTLSCredential"), (Object)clientTLSCred);
        Assert.assertSame((Object)context.getAttribute("javasupport.HostnameVerifier"), (Object)verifier);
        Assert.assertFalse((boolean)((Boolean)context.getAttribute("opensaml.ServerTLSFailureIsFatal")));
    }

    @Test
    public void testSetContextValue() {
        String attribName = "MyAttrib";
        HttpClientContext context = null;
        context = HttpClientContext.create();
        HttpClientSecuritySupport.setContextValue((HttpClientContext)context, (String)attribName, (Object)"foo", (boolean)false);
        Assert.assertEquals((Object)context.getAttribute(attribName), (Object)"foo");
        context = HttpClientContext.create();
        HttpClientSecuritySupport.setContextValue((HttpClientContext)context, (String)attribName, null, (boolean)false);
        Assert.assertNull((Object)context.getAttribute(attribName));
        context = HttpClientContext.create();
        context.setAttribute(attribName, (Object)"bar");
        HttpClientSecuritySupport.setContextValue((HttpClientContext)context, (String)attribName, (Object)"foo", (boolean)false);
        Assert.assertEquals((Object)context.getAttribute(attribName), (Object)"bar");
        context = HttpClientContext.create();
        context.setAttribute(attribName, (Object)"bar");
        HttpClientSecuritySupport.setContextValue((HttpClientContext)context, (String)attribName, (Object)"foo", (boolean)true);
        Assert.assertEquals((Object)context.getAttribute(attribName), (Object)"foo");
        context = HttpClientContext.create();
        context.setAttribute(attribName, (Object)"bar");
        HttpClientSecuritySupport.setContextValue((HttpClientContext)context, (String)attribName, null, (boolean)true);
        Assert.assertEquals((Object)context.getAttribute(attribName), (Object)"bar");
        try {
            HttpClientSecuritySupport.setContextValue(null, (String)attribName, (Object)"foo", (boolean)false);
            Assert.fail((String)"Null context value");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            context = HttpClientContext.create();
            HttpClientSecuritySupport.setContextValue((HttpClientContext)context, null, (Object)"foo", (boolean)false);
            Assert.fail((String)"Null attribute name");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @DataProvider
    private Object[][] tlsCredentialEvaluatedData() {
        MockTrustEngine trustEngine = new MockTrustEngine();
        return new Object[][]{{trustEngine, "https", Boolean.TRUE, true}, {trustEngine, "https", Boolean.FALSE, true}, {null, "https", null, true}, {null, "https", Boolean.TRUE, true}, {null, "https", Boolean.FALSE, true}, {trustEngine, "http", null, true}, {trustEngine, "http", Boolean.TRUE, true}, {trustEngine, "http", Boolean.FALSE, true}, {trustEngine, "https", null, false}};
    }

    @Test(dataProvider="tlsCredentialEvaluatedData")
    public void testCheckTLSCredentialEvaluated(MockTrustEngine trustEngine, String scheme, Boolean trusted, boolean shouldPass) {
        HttpClientContext context = new HttpClientContext();
        context.setAttribute("opensaml.TrustEngine", (Object)trustEngine);
        context.setAttribute("opensaml.ServerTLSCredentialTrusted", (Object)trusted);
        if (shouldPass) {
            try {
                HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)context, (String)scheme);
            }
            catch (SSLPeerUnverifiedException e) {
                Assert.fail((String)"Exception thrown unexpectedly");
            }
        } else {
            try {
                HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)context, (String)scheme);
                Assert.fail((String)"Exception was expected but not seen");
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAddDefaultTLSTrustEngineCriteria() {
        HttpGet request = new HttpGet("https://www.example.com/foobar");
        HttpClientContext context = new HttpClientContext();
        context.setAttribute("opensaml.TrustEngine", (Object)new MockTrustEngine());
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)context, (HttpUriRequest)request);
        CriteriaSet criteria = (CriteriaSet)context.getAttribute("opensaml.CriteriaSet");
        Assert.assertNotNull((Object)criteria);
        UsageCriterion usage = (UsageCriterion)criteria.get(UsageCriterion.class);
        Assert.assertNotNull((Object)usage);
        Assert.assertEquals((Object)usage.getUsage(), (Object)UsageType.SIGNING);
        TrustedNamesCriterion trustedNames = (TrustedNamesCriterion)criteria.get(TrustedNamesCriterion.class);
        Assert.assertNotNull((Object)trustedNames);
        Assert.assertEquals((int)trustedNames.getTrustedNames().size(), (int)1);
        Assert.assertTrue((boolean)trustedNames.getTrustedNames().contains("www.example.com"));
        request = new HttpGet("http://www.example.com/foobar");
        context = new HttpClientContext();
        context.setAttribute("opensaml.TrustEngine", (Object)new MockTrustEngine());
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)context, (HttpUriRequest)request);
        Assert.assertNull((Object)context.getAttribute("opensaml.CriteriaSet"));
        request = new HttpGet("https://www.example.com/foobar");
        context = new HttpClientContext();
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)context, (HttpUriRequest)request);
        Assert.assertNull((Object)context.getAttribute("opensaml.CriteriaSet"));
    }

    public static class MockTrustEngine
    implements TrustEngine<X509Credential> {
        public boolean validate(X509Credential token, CriteriaSet trustBasisCriteria) throws SecurityException {
            return false;
        }
    }
}

