/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriteriaRegistry;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.credential.criteria.impl.EvaluableUsageCredentialCriterion;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.crypto.KeySupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EvaluableUsageCredentialCriterionTest {
    private BasicCredential credential;
    private UsageType usage = UsageType.SIGNING;
    private UsageCriterion criteria;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.credential = new BasicCredential(KeySupport.generateKey((String)"AES", (int)128, null));
        this.credential.setUsageType(this.usage);
        this.criteria = new UsageCriterion(this.usage);
    }

    @Test
    public void testSatisfyExactMatch() {
        EvaluableUsageCredentialCriterion evalCrit = new EvaluableUsageCredentialCriterion(this.criteria);
        Assert.assertTrue((boolean)evalCrit.test((Credential)this.credential), (String)"Credential should have matched the evaluable criteria");
    }

    @Test
    public void testSatisfyWithUnspecifiedCriteria() {
        this.criteria.setUsage(UsageType.UNSPECIFIED);
        EvaluableUsageCredentialCriterion evalCrit = new EvaluableUsageCredentialCriterion(this.criteria);
        Assert.assertTrue((boolean)evalCrit.test((Credential)this.credential), (String)"Credential should have matched the evaluable criteria");
    }

    @Test
    public void testSatisfyWithUnspecifiedCredential() {
        this.credential.setUsageType(UsageType.UNSPECIFIED);
        EvaluableUsageCredentialCriterion evalCrit = new EvaluableUsageCredentialCriterion(this.criteria);
        Assert.assertTrue((boolean)evalCrit.test((Credential)this.credential), (String)"Credential should have matched the evaluable criteria");
    }

    @Test
    public void testNotSatisfy() {
        this.criteria.setUsage(UsageType.ENCRYPTION);
        EvaluableUsageCredentialCriterion evalCrit = new EvaluableUsageCredentialCriterion(this.criteria);
        Assert.assertFalse((boolean)evalCrit.test((Credential)this.credential), (String)"Credential should NOT have matched the evaluable criteria");
    }

    @Test
    public void testRegistry() throws Exception {
        EvaluableCredentialCriterion evalCrit = EvaluableCredentialCriteriaRegistry.getEvaluator((Criterion)this.criteria);
        Assert.assertNotNull((Object)evalCrit, (String)"Evaluable criteria was unavailable from the registry");
        Assert.assertTrue((boolean)evalCrit.test((Object)this.credential), (String)"Credential should have matched the evaluable criteria");
    }
}

