/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriteriaRegistry;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.credential.criteria.impl.EvaluableX509IssuerSerialCredentialCriterion;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509IssuerSerialCriterion;
import org.opensaml.security.x509.X509Support;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EvaluableX509IssuerSerialCredentialCriterionTest {
    private BasicX509Credential credential;
    private BigInteger serialNumber;
    private X500Principal issuerName;
    private X509IssuerSerialCriterion criteria;
    private X509Certificate entityCert;
    private String entityCertBase64 = "MIIDzjCCAragAwIBAgIBMTANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDUyMTE4MjM0MFoXDTE3MDUxODE4MjM0MFowMTESMBAGA1UEChMJSW50ZXJuZXQyMRswGQYDVQQDExJmb29iYXIuZXhhbXBsZS5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDNWnkFmhy1vYa6gN/xBRKkZxFy3sUq2V0LsYb6Q3pe9Qlb6+BzaM5DrN8uIqqroBE3Wp0LtrgKuQTpDpNFBdS2p5afiUtOYLWBDtizTOzs3Z36MGMjIPUYQ4s03IP3yPh2ud6EKpDPiYqzNbkRaiIwmYSit5r+RMYvd6fuKvTOn6h7PZI5AD7Rda7VWh5OVSoZXlRx3qxFho+mZhW0q4fUfTi5lWwf4EhkfBlzgw/k5gf4cOi6rrGpRS1zxmbtX1RAg+I20z6d04g0N2WsK5stszgYKoIROJCiXwjraa8/SoFcILolWQpttVHBIUYlyDlm8mIFleZf4ReFpfm+nUYxAgMBAAGjgfQwgfEwCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFDgRgTkjaKoK6DoZfUZ4g9LDJUWuMFUGA1UdIwROMEyAFNXuZVPeUdqHrULqQW7yr9buRpQLoTGkLzAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnggEBMEAGA1UdEQQ5MDeCEmFzaW1vdi5leGFtcGxlLm9yZ4YbaHR0cDovL2hlaW5sZWluLmV4YW1wbGUub3JnhwQKAQIDMA0GCSqGSIb3DQEBBQUAA4IBAQBLiDMyQ60ldIytVO1GCpp1S1sKJyTF56GVxHh/82hiRFbyPu+2eSl7UcJfH4ZNbAfHL1vDKTRJ9zoD8WRzpOCUtT0IPIA/Ex+8lFzZmujO10j3TMpp8Ii6+auYwi/Tosrfw1YCxF+GI5KO49CfDRr6yxUbMhbTN+ssK4UzFf36UbkeJ3EfDwB0WU70jnlkyO8f97X6mLd5QvRcwlkDMftP4+MB+inTlxDZ/w8NLXQoDW6p/8r91bupXe0xwuyEvow2xjxlzVcux2BZsUZYjBa07ZmNNBtF7WaQqH7l2OBCAdnBhvme5i/e0LK3Ivys+hcVyvCXs5XtFTFWDAVYvzQ6";

    @BeforeMethod
    protected void setUp() throws Exception {
        this.entityCert = X509Support.decodeCertificate((String)this.entityCertBase64);
        this.issuerName = new X500Principal("cn=ca.example.org, O=Internet2");
        this.serialNumber = new BigInteger("49");
        this.credential = new BasicX509Credential(this.entityCert);
        this.criteria = new X509IssuerSerialCriterion(this.issuerName, this.serialNumber);
    }

    @Test
    public void testSatisfy() {
        EvaluableX509IssuerSerialCredentialCriterion evalCrit = new EvaluableX509IssuerSerialCredentialCriterion(this.criteria);
        Assert.assertTrue((boolean)evalCrit.test((Credential)this.credential), (String)"Credential should have matched the evaluable criteria");
    }

    @Test
    public void testNotSatisfy() {
        this.criteria.setSerialNumber(new BigInteger("100"));
        EvaluableX509IssuerSerialCredentialCriterion evalCrit = new EvaluableX509IssuerSerialCredentialCriterion(this.criteria);
        Assert.assertFalse((boolean)evalCrit.test((Credential)this.credential), (String)"Credential should NOT have matched the evaluable criteria");
    }

    @Test
    public void testNotSatisfyWrongCredType() throws NoSuchAlgorithmException, NoSuchProviderException {
        BasicCredential basicCred = new BasicCredential(KeySupport.generateKey((String)"AES", (int)128, null));
        EvaluableX509IssuerSerialCredentialCriterion evalCrit = new EvaluableX509IssuerSerialCredentialCriterion(this.criteria);
        Assert.assertFalse((boolean)evalCrit.test((Credential)basicCred), (String)"Credential should NOT have matched the evaluable criteria");
    }

    @Test
    public void testRegistry() throws Exception {
        EvaluableCredentialCriterion evalCrit = EvaluableCredentialCriteriaRegistry.getEvaluator((Criterion)this.criteria);
        Assert.assertNotNull((Object)evalCrit, (String)"Evaluable criteria was unavailable from the registry");
        Assert.assertTrue((boolean)evalCrit.test((Object)this.credential), (String)"Credential should have matched the evaluable criteria");
    }
}

