/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient.impl;

import java.io.File;
import java.net.URISyntaxException;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.net.ssl.HostnameVerifier;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.httpclient.HttpClientSecurityConfiguration;
import org.opensaml.security.httpclient.HttpClientSecurityConfigurationCriterion;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.TLSCriteriaSetCriterion;
import org.opensaml.security.httpclient.impl.BasicHttpClientSecurityConfiguration;
import org.opensaml.security.httpclient.impl.BasicHttpClientSecurityParametersResolver;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicHttpClientSecurityParametersResolverTest {
    private BasicHttpClientSecurityParametersResolver resolver;
    private X509Credential x509Credential1;
    private X509Credential x509Credential2;
    private X509Credential x509Credential3;

    @BeforeMethod
    protected void setUp() throws CertificateException, URISyntaxException, KeyException {
        this.resolver = new BasicHttpClientSecurityParametersResolver();
        this.x509Credential1 = CredentialSupport.getSimpleCredential((X509Certificate)X509Support.decodeCertificate((File)new File(this.getClass().getResource("/data/certificate.pem").toURI())), (PrivateKey)KeySupport.decodePrivateKey((File)new File(this.getClass().getResource("/data/rsa-privkey-nopass.pem").toURI()), null));
        this.x509Credential2 = CredentialSupport.getSimpleCredential((X509Certificate)X509Support.decodeCertificate((File)new File(this.getClass().getResource("/data/certificate.pem").toURI())), (PrivateKey)KeySupport.decodePrivateKey((File)new File(this.getClass().getResource("/data/rsa-privkey-nopass.pem").toURI()), null));
        this.x509Credential3 = CredentialSupport.getSimpleCredential((X509Certificate)X509Support.decodeCertificate((File)new File(this.getClass().getResource("/data/certificate.pem").toURI())), (PrivateKey)KeySupport.decodePrivateKey((File)new File(this.getClass().getResource("/data/rsa-privkey-nopass.pem").toURI()), null));
    }

    @Test
    public void testSingleConfigFullyPopulated() throws ResolverException {
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new HttpClientSecurityConfigurationCriterion(new HttpClientSecurityConfiguration[]{this.buildBaseConfiguration(this.x509Credential1)})});
        HttpClientSecurityParameters params = this.resolver.resolveSingle(criteria);
        Assert.assertNotNull((Object)params);
        Assert.assertNull((Object)params.getAuthCache());
        Assert.assertNotNull((Object)params.getClientTLSCredential());
        Assert.assertNotNull((Object)params.getCredentialsProvider());
        Assert.assertNotNull((Object)params.getHostnameVerifier());
        Assert.assertNotNull((Object)params.getTLSCipherSuites());
        Assert.assertNull((Object)params.getTLSCriteriaSet());
        Assert.assertNotNull((Object)params.getTLSProtocols());
        Assert.assertNotNull((Object)params.getTLSTrustEngine());
        Assert.assertNotNull((Object)params.isServerTLSFailureFatal());
    }

    @Test
    public void testSingleConfigEmpty() throws ResolverException {
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new HttpClientSecurityConfigurationCriterion(new HttpClientSecurityConfiguration[]{new BasicHttpClientSecurityConfiguration()})});
        HttpClientSecurityParameters params = this.resolver.resolveSingle(criteria);
        Assert.assertNotNull((Object)params);
        Assert.assertNull((Object)params.getAuthCache());
        Assert.assertNull((Object)params.getClientTLSCredential());
        Assert.assertNull((Object)params.getCredentialsProvider());
        Assert.assertNull((Object)params.getHostnameVerifier());
        Assert.assertNull((Object)params.getTLSCipherSuites());
        Assert.assertNull((Object)params.getTLSCriteriaSet());
        Assert.assertNull((Object)params.getTLSProtocols());
        Assert.assertNull((Object)params.getTLSTrustEngine());
        Assert.assertNull((Object)params.isServerTLSFailureFatal());
    }

    @Test
    public void testMultipleConfigsSimple() throws ResolverException {
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new HttpClientSecurityConfigurationCriterion(new HttpClientSecurityConfiguration[]{this.buildBaseConfiguration(this.x509Credential1), new BasicHttpClientSecurityConfiguration(), new BasicHttpClientSecurityConfiguration()})});
        HttpClientSecurityParameters params = this.resolver.resolveSingle(criteria);
        Assert.assertNotNull((Object)params);
        Assert.assertNull((Object)params.getAuthCache());
        Assert.assertNotNull((Object)params.getClientTLSCredential());
        Assert.assertNotNull((Object)params.getCredentialsProvider());
        Assert.assertNotNull((Object)params.getHostnameVerifier());
        Assert.assertNotNull((Object)params.getTLSCipherSuites());
        Assert.assertNull((Object)params.getTLSCriteriaSet());
        Assert.assertNotNull((Object)params.getTLSProtocols());
        Assert.assertNotNull((Object)params.getTLSTrustEngine());
        Assert.assertNotNull((Object)params.isServerTLSFailureFatal());
        criteria = new CriteriaSet(new Criterion[]{new HttpClientSecurityConfigurationCriterion(new HttpClientSecurityConfiguration[]{new BasicHttpClientSecurityConfiguration(), this.buildBaseConfiguration(this.x509Credential1), new BasicHttpClientSecurityConfiguration()})});
        params = this.resolver.resolveSingle(criteria);
        Assert.assertNotNull((Object)params);
        Assert.assertNull((Object)params.getAuthCache());
        Assert.assertNotNull((Object)params.getClientTLSCredential());
        Assert.assertNotNull((Object)params.getCredentialsProvider());
        Assert.assertNotNull((Object)params.getHostnameVerifier());
        Assert.assertNotNull((Object)params.getTLSCipherSuites());
        Assert.assertNull((Object)params.getTLSCriteriaSet());
        Assert.assertNotNull((Object)params.getTLSProtocols());
        Assert.assertNotNull((Object)params.getTLSTrustEngine());
        Assert.assertNotNull((Object)params.isServerTLSFailureFatal());
        criteria = new CriteriaSet(new Criterion[]{new HttpClientSecurityConfigurationCriterion(new HttpClientSecurityConfiguration[]{new BasicHttpClientSecurityConfiguration(), new BasicHttpClientSecurityConfiguration(), this.buildBaseConfiguration(this.x509Credential1)})});
        params = this.resolver.resolveSingle(criteria);
        Assert.assertNotNull((Object)params);
        Assert.assertNull((Object)params.getAuthCache());
        Assert.assertNotNull((Object)params.getClientTLSCredential());
        Assert.assertNotNull((Object)params.getCredentialsProvider());
        Assert.assertNotNull((Object)params.getHostnameVerifier());
        Assert.assertNotNull((Object)params.getTLSCipherSuites());
        Assert.assertNull((Object)params.getTLSCriteriaSet());
        Assert.assertNotNull((Object)params.getTLSProtocols());
        Assert.assertNotNull((Object)params.getTLSTrustEngine());
        Assert.assertNotNull((Object)params.isServerTLSFailureFatal());
    }

    @Test
    public void testMultipleConfigsLayered() throws ResolverException {
        BasicHttpClientSecurityConfiguration config1 = this.buildBaseConfiguration(this.x509Credential1);
        BasicHttpClientSecurityConfiguration config2 = this.buildBaseConfiguration(this.x509Credential2);
        BasicHttpClientSecurityConfiguration config3 = this.buildBaseConfiguration(this.x509Credential3);
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new HttpClientSecurityConfigurationCriterion(new HttpClientSecurityConfiguration[]{config1, config2, config3})});
        HttpClientSecurityParameters params = this.resolver.resolveSingle(criteria);
        Assert.assertNotNull((Object)params);
        Assert.assertNotNull((Object)params.getClientTLSCredential());
        Assert.assertSame((Object)params.getClientTLSCredential(), (Object)config1.getClientTLSCredential());
        config1.setClientTLSCredential(null);
        criteria = new CriteriaSet(new Criterion[]{new HttpClientSecurityConfigurationCriterion(new HttpClientSecurityConfiguration[]{config1, config2, config3})});
        params = this.resolver.resolveSingle(criteria);
        Assert.assertNotNull((Object)params);
        Assert.assertNotNull((Object)params.getClientTLSCredential());
        Assert.assertSame((Object)params.getClientTLSCredential(), (Object)config2.getClientTLSCredential());
        config2.setClientTLSCredential(null);
        criteria = new CriteriaSet(new Criterion[]{new HttpClientSecurityConfigurationCriterion(new HttpClientSecurityConfiguration[]{config1, config2, config3})});
        params = this.resolver.resolveSingle(criteria);
        Assert.assertNotNull((Object)params);
        Assert.assertNotNull((Object)params.getClientTLSCredential());
        Assert.assertSame((Object)params.getClientTLSCredential(), (Object)config3.getClientTLSCredential());
    }

    @Test
    public void testTLSCriteriaSet() throws ResolverException {
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new HttpClientSecurityConfigurationCriterion(new HttpClientSecurityConfiguration[]{new BasicHttpClientSecurityConfiguration()})});
        criteria.add((Object)new TLSCriteriaSetCriterion(new CriteriaSet()));
        HttpClientSecurityParameters params = this.resolver.resolveSingle(criteria);
        Assert.assertNotNull((Object)params);
        Assert.assertNotNull((Object)params.getTLSCriteriaSet());
    }

    private BasicHttpClientSecurityConfiguration buildBaseConfiguration(X509Credential x509Credential) {
        BasicHttpClientSecurityConfiguration config = new BasicHttpClientSecurityConfiguration();
        config.setClientTLSCredential(x509Credential);
        config.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        config.setHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier());
        config.setTLSCipherSuites(Collections.singletonList("test"));
        config.setTLSProtocols(Collections.singletonList("test"));
        config.setTLSTrustEngine((TrustEngine)new MockTrustEngine());
        config.setServerTLSFailureFatal(Boolean.valueOf(true));
        return config;
    }

    public static class MockTrustEngine
    implements TrustEngine<X509Credential> {
        public boolean validate(X509Credential token, CriteriaSet trustBasisCriteria) throws SecurityException {
            return false;
        }
    }
}

