/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.httpclient.impl.MockTLSSocketFactory;
import org.opensaml.security.httpclient.impl.SecurityEnhancedTLSSocketFactory;
import org.opensaml.security.httpclient.impl.ThreadLocalClientTLSCredentialHandler;
import org.opensaml.security.httpclient.impl.ThreadLocalServerTLSHandler;
import org.opensaml.security.trust.impl.ExplicitKeyTrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509CredentialContext;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509TrustEngineContext;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SecurityEnhancedTLSSocketFactoryTest {
    private static final String DATA_PATH = "/org/opensaml/security/x509/impl/";
    private SecurityEnhancedTLSSocketFactory securityEnhancedSocketFactory;
    private HttpContext httpContext;
    private String hostname = "foo.example.org";

    @BeforeMethod
    public void buildHttpContext() {
        this.httpContext = new HttpClientContext();
    }

    @AfterMethod
    public void clearThreadLocals() {
        ThreadLocalX509TrustEngineContext.clearCurrent();
        ThreadLocalX509CredentialContext.clearCurrent();
    }

    @Test
    public void testNoContextParametersHTTP() throws IOException {
        this.securityEnhancedSocketFactory = new SecurityEnhancedTLSSocketFactory(this.buildInnerSSLFactory(null, this.hostname));
        Socket socket = this.securityEnhancedSocketFactory.createSocket(this.httpContext);
        this.securityEnhancedSocketFactory.connectSocket(0, socket, new HttpHost(this.hostname, 80, "http"), null, null, this.httpContext);
        Assert.assertFalse((boolean)ThreadLocalX509TrustEngineContext.haveCurrent());
        Assert.assertFalse((boolean)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)HttpClientContext.adapt((HttpContext)this.httpContext)).stream().anyMatch(h -> ThreadLocalServerTLSHandler.class.isInstance(h)));
        Assert.assertFalse((boolean)ThreadLocalX509CredentialContext.haveCurrent());
        Assert.assertFalse((boolean)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)HttpClientContext.adapt((HttpContext)this.httpContext)).stream().anyMatch(h -> ThreadLocalClientTLSCredentialHandler.class.isInstance(h)));
    }

    @Test
    public void testNoContextParametersHTTPS() throws IOException {
        BasicX509Credential cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        this.securityEnhancedSocketFactory = new SecurityEnhancedTLSSocketFactory(this.buildInnerSSLFactory(Collections.singletonList(cred.getEntityCertificate()), this.hostname));
        Socket socket = this.securityEnhancedSocketFactory.createSocket(this.httpContext);
        this.securityEnhancedSocketFactory.connectSocket(0, socket, new HttpHost(this.hostname, 443, "https"), null, null, this.httpContext);
        Assert.assertFalse((boolean)ThreadLocalX509TrustEngineContext.haveCurrent());
        Assert.assertFalse((boolean)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)HttpClientContext.adapt((HttpContext)this.httpContext)).stream().anyMatch(h -> ThreadLocalServerTLSHandler.class.isInstance(h)));
        Assert.assertFalse((boolean)ThreadLocalX509CredentialContext.haveCurrent());
        Assert.assertFalse((boolean)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)HttpClientContext.adapt((HttpContext)this.httpContext)).stream().anyMatch(h -> ThreadLocalClientTLSCredentialHandler.class.isInstance(h)));
    }

    @Test
    public void testEngineParamWithDefaultCriteria() throws IOException {
        BasicX509Credential cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        ExplicitKeyTrustEngine trustEngine = new ExplicitKeyTrustEngine((CredentialResolver)new StaticCredentialResolver((Credential)cred));
        this.httpContext.setAttribute("opensaml.TrustEngine", (Object)trustEngine);
        this.securityEnhancedSocketFactory = new SecurityEnhancedTLSSocketFactory(this.buildInnerSSLFactory(Collections.singletonList(cred.getEntityCertificate()), this.hostname));
        Socket socket = this.securityEnhancedSocketFactory.createSocket(this.httpContext);
        this.securityEnhancedSocketFactory.connectSocket(0, socket, new HttpHost(this.hostname, 443, "https"), null, null, this.httpContext);
        Assert.assertTrue((boolean)ThreadLocalX509TrustEngineContext.haveCurrent());
        Assert.assertSame((Object)ThreadLocalX509TrustEngineContext.getTrustEngine(), (Object)trustEngine);
        Assert.assertNotNull((Object)ThreadLocalX509TrustEngineContext.getCriteria());
        Assert.assertTrue((boolean)ThreadLocalX509TrustEngineContext.isFailureFatal());
        Assert.assertTrue((boolean)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)HttpClientContext.adapt((HttpContext)this.httpContext)).stream().anyMatch(h -> ThreadLocalServerTLSHandler.class.isInstance(h)));
        Assert.assertFalse((boolean)ThreadLocalX509CredentialContext.haveCurrent());
        Assert.assertFalse((boolean)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)HttpClientContext.adapt((HttpContext)this.httpContext)).stream().anyMatch(h -> ThreadLocalClientTLSCredentialHandler.class.isInstance(h)));
    }

    @Test
    public void testEngineParamWithExplicitCriteria() throws IOException {
        BasicX509Credential cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        ExplicitKeyTrustEngine trustEngine = new ExplicitKeyTrustEngine((CredentialResolver)new StaticCredentialResolver((Credential)cred));
        this.httpContext.setAttribute("opensaml.TrustEngine", (Object)trustEngine);
        CriteriaSet criteria = new CriteriaSet();
        this.httpContext.setAttribute("opensaml.CriteriaSet", (Object)criteria);
        this.securityEnhancedSocketFactory = new SecurityEnhancedTLSSocketFactory(this.buildInnerSSLFactory(Collections.singletonList(cred.getEntityCertificate()), this.hostname));
        Socket socket = this.securityEnhancedSocketFactory.createSocket(this.httpContext);
        this.securityEnhancedSocketFactory.connectSocket(0, socket, new HttpHost(this.hostname, 443, "https"), null, null, this.httpContext);
        Assert.assertTrue((boolean)ThreadLocalX509TrustEngineContext.haveCurrent());
        Assert.assertSame((Object)ThreadLocalX509TrustEngineContext.getTrustEngine(), (Object)trustEngine);
        Assert.assertSame((Object)ThreadLocalX509TrustEngineContext.getCriteria(), (Object)criteria);
        Assert.assertTrue((boolean)ThreadLocalX509TrustEngineContext.isFailureFatal());
        Assert.assertTrue((boolean)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)HttpClientContext.adapt((HttpContext)this.httpContext)).stream().anyMatch(h -> ThreadLocalServerTLSHandler.class.isInstance(h)));
        Assert.assertFalse((boolean)ThreadLocalX509CredentialContext.haveCurrent());
        Assert.assertFalse((boolean)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)HttpClientContext.adapt((HttpContext)this.httpContext)).stream().anyMatch(h -> ThreadLocalClientTLSCredentialHandler.class.isInstance(h)));
    }

    @Test
    public void testEngineParamWithFailureNonFatal() throws IOException {
        BasicX509Credential cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        ExplicitKeyTrustEngine trustEngine = new ExplicitKeyTrustEngine((CredentialResolver)new StaticCredentialResolver((Credential)cred));
        this.httpContext.setAttribute("opensaml.TrustEngine", (Object)trustEngine);
        this.httpContext.setAttribute("opensaml.ServerTLSFailureIsFatal", (Object)Boolean.FALSE);
        CriteriaSet criteria = new CriteriaSet();
        this.httpContext.setAttribute("opensaml.CriteriaSet", (Object)criteria);
        this.securityEnhancedSocketFactory = new SecurityEnhancedTLSSocketFactory(this.buildInnerSSLFactory(Collections.singletonList(cred.getEntityCertificate()), this.hostname));
        Socket socket = this.securityEnhancedSocketFactory.createSocket(this.httpContext);
        this.securityEnhancedSocketFactory.connectSocket(0, socket, new HttpHost(this.hostname, 443, "https"), null, null, this.httpContext);
        Assert.assertTrue((boolean)ThreadLocalX509TrustEngineContext.haveCurrent());
        Assert.assertSame((Object)ThreadLocalX509TrustEngineContext.getTrustEngine(), (Object)trustEngine);
        Assert.assertNotNull((Object)ThreadLocalX509TrustEngineContext.getCriteria());
        Assert.assertFalse((boolean)ThreadLocalX509TrustEngineContext.isFailureFatal());
        Assert.assertTrue((boolean)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)HttpClientContext.adapt((HttpContext)this.httpContext)).stream().anyMatch(h -> ThreadLocalServerTLSHandler.class.isInstance(h)));
        Assert.assertFalse((boolean)ThreadLocalX509CredentialContext.haveCurrent());
        Assert.assertFalse((boolean)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)HttpClientContext.adapt((HttpContext)this.httpContext)).stream().anyMatch(h -> ThreadLocalClientTLSCredentialHandler.class.isInstance(h)));
    }

    @Test
    public void testClientTLSParam() throws IOException {
        BasicX509Credential cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        this.httpContext.setAttribute("opensaml.ClientTLSCredential", (Object)cred);
        this.securityEnhancedSocketFactory = new SecurityEnhancedTLSSocketFactory(this.buildInnerSSLFactory(null, this.hostname));
        Socket socket = this.securityEnhancedSocketFactory.createSocket(this.httpContext);
        this.securityEnhancedSocketFactory.connectSocket(0, socket, new HttpHost(this.hostname, 443, "https"), null, null, this.httpContext);
        Assert.assertFalse((boolean)ThreadLocalX509TrustEngineContext.haveCurrent());
        Assert.assertFalse((boolean)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)HttpClientContext.adapt((HttpContext)this.httpContext)).stream().anyMatch(h -> ThreadLocalServerTLSHandler.class.isInstance(h)));
        Assert.assertTrue((boolean)ThreadLocalX509CredentialContext.haveCurrent());
        Assert.assertSame((Object)ThreadLocalX509CredentialContext.getCredential(), (Object)cred);
        Assert.assertTrue((boolean)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)HttpClientContext.adapt((HttpContext)this.httpContext)).stream().anyMatch(h -> ThreadLocalClientTLSCredentialHandler.class.isInstance(h)));
    }

    private LayeredConnectionSocketFactory buildInnerSSLFactory(List<Certificate> certs, String host) {
        if (certs == null) {
            return new MockTLSSocketFactory();
        }
        return new MockTLSSocketFactory(certs, host);
    }

    private BasicX509Credential getCredential(String entityCertFileName, String ... chainMembers) {
        X509Certificate entityCert = this.getCertificate(entityCertFileName);
        BasicX509Credential cred = new BasicX509Credential(entityCert);
        HashSet<X509Certificate> certChain = new HashSet<X509Certificate>();
        certChain.add(entityCert);
        for (String member : chainMembers) {
            certChain.add(this.getCertificate(member));
        }
        cred.setEntityCertificateChain(certChain);
        return cred;
    }

    private X509Certificate getCertificate(String fileName) {
        try {
            InputStream ins = this.getInputStream(fileName);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return (X509Certificate)X509Support.decodeCertificates((byte[])encoded).iterator().next();
        }
        catch (Exception e) {
            Assert.fail((String)("Could not create certificate from file: " + fileName + ": " + e.getMessage()));
            return null;
        }
    }

    private InputStream getInputStream(String fileName) {
        return this.getClass().getResourceAsStream(DATA_PATH + fileName);
    }
}

