/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.trust.impl;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.trust.impl.ChainingTrustEngine;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ChainingTrustEngineTest {
    private CriteriaSet criteriaSet;
    private ChainingTrustEngine<FooToken> engine;
    private List<TrustEngine<? super FooToken>> chain;
    private FooToken token;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.token = new FooToken();
        this.chain = new ArrayList<TrustEngine<? super FooToken>>();
        this.criteriaSet = new CriteriaSet();
        this.criteriaSet.add((Object)new EntityIdCriterion("dummyEntityID"));
    }

    @Test
    public void testFirstTrusted() throws SecurityException {
        this.chain.add(new FooEngine(Boolean.TRUE));
        this.chain.add(new FooEngine(Boolean.FALSE));
        this.engine = new ChainingTrustEngine(this.chain);
        Assert.assertTrue((boolean)this.engine.validate((Object)this.token, this.criteriaSet), (String)"Engine # 1 evaled token as trusted");
    }

    @Test
    public void testSecondTrusted() throws SecurityException {
        this.chain.add(new FooEngine(Boolean.FALSE));
        this.chain.add(new FooEngine(Boolean.TRUE));
        this.engine = new ChainingTrustEngine(this.chain);
        Assert.assertTrue((boolean)this.engine.validate((Object)this.token, this.criteriaSet), (String)"Engine # 2 evaled token as trusted");
    }

    @Test
    public void testNoneTrusted() throws SecurityException {
        this.chain.add(new FooEngine(Boolean.FALSE));
        this.chain.add(new FooEngine(Boolean.FALSE));
        this.engine = new ChainingTrustEngine(this.chain);
        Assert.assertFalse((boolean)this.engine.validate((Object)this.token, this.criteriaSet), (String)"No engine evaled token as trusted");
    }

    @Test
    public void testMixedEngines() throws SecurityException {
        this.chain.add(new FooEngine(Boolean.FALSE));
        this.chain.add(new SuperEngine(Boolean.TRUE));
        this.engine = new ChainingTrustEngine(this.chain);
        Assert.assertTrue((boolean)this.engine.validate((Object)this.token, this.criteriaSet), (String)"SuperEngine evaled token as trusted");
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testException() throws SecurityException {
        this.chain.add(new FooEngine(Boolean.FALSE));
        this.chain.add(new FooEngine(null));
        this.engine = new ChainingTrustEngine(this.chain);
        this.engine.validate((Object)this.token, this.criteriaSet);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullChain() {
        this.engine = new ChainingTrustEngine(null);
    }

    private class FooToken
    extends SuperToken {
        private FooToken() {
        }
    }

    private class FooEngine
    implements TrustEngine<FooToken> {
        private Boolean trusted;

        private FooEngine(Boolean flag) {
            this.trusted = flag;
        }

        public boolean validate(FooToken token1, CriteriaSet trustBasisCriteria) throws SecurityException {
            if (this.trusted == null) {
                throw new SecurityException("This means an error happened");
            }
            return this.trusted;
        }
    }

    private class SuperEngine
    implements TrustEngine<SuperToken> {
        private Boolean trusted;

        private SuperEngine(Boolean flag) {
            this.trusted = flag;
        }

        public boolean validate(SuperToken token1, CriteriaSet trustBasisCriteria) throws SecurityException {
            if (this.trusted == null) {
                throw new SecurityException("This means an error happened");
            }
            return this.trusted;
        }
    }

    private class SuperToken {
        private SuperToken() {
        }
    }
}

