/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.trust.impl;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.SSLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.annotation.Nonnull;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLSocketFactory;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class InMemoryDirectory {
    @Nonnull
    private final InMemoryDirectoryServer directoryServer;

    public InMemoryDirectory(@Nonnull File ldif, @Nonnull File keystore) throws LDAPException, IOException {
        Constraint.isNotNull((Object)ldif, (String)"LDIF resource cannot be null");
        InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{"dc=example,dc=org"});
        try {
            SSLUtil sslUtil = new SSLUtil((KeyManager)new KeyStoreKeyManager(keystore, "changeit".toCharArray()), null);
            config.setListenerConfigs(new InMemoryListenerConfig[]{InMemoryListenerConfig.createLDAPConfig((String)"default", null, (int)10389, (SSLSocketFactory)sslUtil.createSSLSocketFactory())});
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error reading keystore", e);
        }
        config.addAdditionalBindCredentials("cn=Directory Manager", "password");
        this.directoryServer = new InMemoryDirectoryServer(config);
        this.directoryServer.importFromLDIF(true, new LDIFReader((InputStream)new FileInputStream(ldif)));
    }

    public void start() throws LDAPException {
        this.directoryServer.startListening();
    }

    public void stop() {
        this.directoryServer.shutDown(true);
    }
}

