/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.trust.impl;

import com.unboundid.ldap.sdk.LDAPException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.net.ssl.TrustManager;
import org.cryptacular.util.KeyPairUtil;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.ssl.SslConfig;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.trust.impl.ExplicitKeyTrustEngine;
import org.opensaml.security.trust.impl.InMemoryDirectory;
import org.opensaml.security.trust.impl.TrustEngineX509TrustManager;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TrustEngineX509TrustManagerTest {
    private static final String DATA_PATH = "src/test/resources/org/opensaml/security/ldap/impl/";
    private InMemoryDirectory directoryServer;
    private final String context = "ou=people,dc=example,dc=org";

    @BeforeClass
    public void setupDirectoryServer() throws IOException, LDAPException {
        this.directoryServer = new InMemoryDirectory(new File("src/test/resources/org/opensaml/security/ldap/impl/test-ldap.ldif"), new File("src/test/resources/org/opensaml/security/ldap/impl/test-ldap.keystore"));
        this.directoryServer.start();
    }

    @AfterClass
    public void teardownDirectoryServer() {
        this.directoryServer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={LdapException.class})
    public void testDefaultTrust() throws LdapException {
        ConnectionConfig config = new ConnectionConfig();
        config.setLdapUrl("ldap://localhost:10389");
        config.setUseStartTLS(true);
        DefaultConnectionFactory factory = new DefaultConnectionFactory(config);
        try (Connection conn = factory.getConnection();){
            conn.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={LdapException.class})
    public void testNullTrust() throws LdapException {
        TrustEngineX509TrustManager trustManager = new TrustEngineX509TrustManager();
        SslConfig sslConfig = new SslConfig();
        sslConfig.setTrustManagers(new TrustManager[]{trustManager});
        ConnectionConfig config = new ConnectionConfig();
        config.setLdapUrl("ldap://localhost:10389");
        config.setUseStartTLS(true);
        config.setSslConfig(sslConfig);
        DefaultConnectionFactory factory = new DefaultConnectionFactory(config);
        try (Connection conn = factory.getConnection();){
            conn.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStaticTrust() throws LdapException, FileNotFoundException, IOException {
        StaticCredentialResolver resolver;
        try (FileInputStream is = new FileInputStream(new File("src/test/resources/org/opensaml/security/ldap/impl/test-ldap.key"));){
            resolver = new StaticCredentialResolver((Credential)new BasicCredential(KeyPairUtil.readPublicKey((InputStream)is)));
        }
        TrustEngineX509TrustManager trustManager = new TrustEngineX509TrustManager();
        trustManager.setTLSTrustEngine((TrustEngine)new ExplicitKeyTrustEngine((CredentialResolver)resolver));
        SslConfig sslConfig = new SslConfig();
        sslConfig.setTrustManagers(new TrustManager[]{trustManager});
        ConnectionConfig config = new ConnectionConfig();
        config.setLdapUrl("ldap://localhost:10389");
        config.setUseStartTLS(true);
        config.setSslConfig(sslConfig);
        DefaultConnectionFactory factory = new DefaultConnectionFactory(config);
        try (Connection conn = factory.getConnection();){
            conn.open();
            this.doSearch(conn);
        }
    }

    protected void doSearch(@Nonnull Connection conn) throws LdapException {
        SearchOperation search = new SearchOperation(conn);
        Response result = search.execute((Request)SearchRequest.newObjectScopeSearchRequest((String)"ou=people,dc=example,dc=org", (String[])new String[]{"description"}));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getResultCode(), (Object)ResultCode.SUCCESS);
    }
}

