/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.impl;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.security.x509.impl.BasicX509CredentialNameEvaluator;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicX509CredentialNameEvaluatorTest
extends XMLObjectBaseTestCase {
    private X509Certificate entityCert3AltNamesDNS_URL_IP;
    private String entityCert3AltNamesDNS_URL_IPBase64 = "MIIDzjCCAragAwIBAgIBMTANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDUyMTE4MjM0MFoXDTE3MDUxODE4MjM0MFowMTESMBAGA1UEChMJSW50ZXJuZXQyMRswGQYDVQQDExJmb29iYXIuZXhhbXBsZS5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDNWnkFmhy1vYa6gN/xBRKkZxFy3sUq2V0LsYb6Q3pe9Qlb6+BzaM5DrN8uIqqroBE3Wp0LtrgKuQTpDpNFBdS2p5afiUtOYLWBDtizTOzs3Z36MGMjIPUYQ4s03IP3yPh2ud6EKpDPiYqzNbkRaiIwmYSit5r+RMYvd6fuKvTOn6h7PZI5AD7Rda7VWh5OVSoZXlRx3qxFho+mZhW0q4fUfTi5lWwf4EhkfBlzgw/k5gf4cOi6rrGpRS1zxmbtX1RAg+I20z6d04g0N2WsK5stszgYKoIROJCiXwjraa8/SoFcILolWQpttVHBIUYlyDlm8mIFleZf4ReFpfm+nUYxAgMBAAGjgfQwgfEwCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFDgRgTkjaKoK6DoZfUZ4g9LDJUWuMFUGA1UdIwROMEyAFNXuZVPeUdqHrULqQW7yr9buRpQLoTGkLzAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnggEBMEAGA1UdEQQ5MDeCEmFzaW1vdi5leGFtcGxlLm9yZ4YbaHR0cDovL2hlaW5sZWluLmV4YW1wbGUub3JnhwQKAQIDMA0GCSqGSIb3DQEBBQUAA4IBAQBLiDMyQ60ldIytVO1GCpp1S1sKJyTF56GVxHh/82hiRFbyPu+2eSl7UcJfH4ZNbAfHL1vDKTRJ9zoD8WRzpOCUtT0IPIA/Ex+8lFzZmujO10j3TMpp8Ii6+auYwi/Tosrfw1YCxF+GI5KO49CfDRr6yxUbMhbTN+ssK4UzFf36UbkeJ3EfDwB0WU70jnlkyO8f97X6mLd5QvRcwlkDMftP4+MB+inTlxDZ/w8NLXQoDW6p/8r91bupXe0xwuyEvow2xjxlzVcux2BZsUZYjBa07ZmNNBtF7WaQqH7l2OBCAdnBhvme5i/e0LK3Ivys+hcVyvCXs5XtFTFWDAVYvzQ6";
    private BasicX509CredentialNameEvaluator evaluator;
    private X509Credential cred;
    private Set<String> names;
    private String subjectCN;
    private String subjectDN;
    private String altNameDNS;
    private String altNameURL;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.entityCert3AltNamesDNS_URL_IP = X509Support.decodeCertificate((String)this.entityCert3AltNamesDNS_URL_IPBase64);
        this.cred = CredentialSupport.getSimpleCredential((X509Certificate)this.entityCert3AltNamesDNS_URL_IP, null);
        this.subjectCN = "foobar.example.org";
        this.subjectDN = "cn=foobar.example.org, O=Internet2";
        this.altNameDNS = "asimov.example.org";
        this.altNameURL = "http://heinlein.example.org";
        this.names = new HashSet<String>();
        this.evaluator = new BasicX509CredentialNameEvaluator();
        this.evaluator.setCheckSubjectAltNames(true);
        this.evaluator.setCheckSubjectDN(true);
        this.evaluator.setCheckSubjectDNCommonName(true);
        this.evaluator.setSubjectAltNameTypes(new HashSet<Integer>(Arrays.asList(X509Support.DNS_ALT_NAME, X509Support.URI_ALT_NAME)));
    }

    @Test
    public void testCommonNameSuccess() {
        this.evaluator.setCheckSubjectAltNames(false);
        this.evaluator.setCheckSubjectDN(false);
        this.evaluator.setCheckSubjectDNCommonName(true);
        this.names.add(this.subjectCN);
        this.testEvaluateSuccess("Subject common name was valid", this.names, this.cred);
    }

    @Test
    public void testCommonNameFail() {
        this.evaluator.setCheckSubjectAltNames(false);
        this.evaluator.setCheckSubjectDN(false);
        this.evaluator.setCheckSubjectDNCommonName(true);
        this.names.add("blah.internet2.edu");
        this.testEvaluateFailure("Subject common name was invalid", this.names, this.cred);
    }

    @Test
    public void testSubjectDNSuccess() {
        this.evaluator.setCheckSubjectAltNames(false);
        this.evaluator.setCheckSubjectDN(true);
        this.evaluator.setCheckSubjectDNCommonName(false);
        this.names.add(this.subjectDN);
        this.testEvaluateSuccess("Subject DN was valid", this.names, this.cred);
    }

    @Test
    public void testSubjectDNFail() {
        this.evaluator.setCheckSubjectAltNames(false);
        this.evaluator.setCheckSubjectDN(true);
        this.evaluator.setCheckSubjectDNCommonName(false);
        this.names.add("cn=blah.internet2.edu,OU=ShibDev,O=Internet2");
        this.testEvaluateFailure("Subject DN was invalid", this.names, this.cred);
    }

    @Test
    public void testSubjectDNInputNotDN() {
        this.evaluator.setCheckSubjectAltNames(false);
        this.evaluator.setCheckSubjectDN(true);
        this.evaluator.setCheckSubjectDNCommonName(false);
        this.names.add(this.subjectCN);
        this.testEvaluateFailure("Subject DN was invalid, was not in DN syntax", this.names, this.cred);
    }

    @Test
    public void testDNSAltNameSuccess() {
        this.evaluator.setCheckSubjectAltNames(true);
        this.evaluator.setCheckSubjectDN(false);
        this.evaluator.setCheckSubjectDNCommonName(false);
        this.evaluator.setSubjectAltNameTypes(Collections.singleton(X509Support.DNS_ALT_NAME));
        this.names.add(this.altNameDNS);
        this.testEvaluateSuccess("DNS subject alt name was valid", this.names, this.cred);
    }

    @Test
    public void testDNSAltNameFail() {
        this.evaluator.setCheckSubjectAltNames(true);
        this.evaluator.setCheckSubjectDN(false);
        this.evaluator.setCheckSubjectDNCommonName(false);
        this.evaluator.setSubjectAltNameTypes(Collections.singleton(X509Support.DNS_ALT_NAME));
        this.names.add("wacky.internet2.edu");
        this.testEvaluateFailure("DNS subject alt name was invalid", this.names, this.cred);
    }

    @Test
    public void testURLAltNameSuccess() {
        this.evaluator.setCheckSubjectAltNames(true);
        this.evaluator.setCheckSubjectDN(false);
        this.evaluator.setCheckSubjectDNCommonName(false);
        this.evaluator.setSubjectAltNameTypes(Collections.singleton(X509Support.URI_ALT_NAME));
        this.names.add(this.altNameURL);
        this.testEvaluateSuccess("URL subject alt name was valid", this.names, this.cred);
    }

    @Test
    public void testURLAltNameFail() {
        this.evaluator.setCheckSubjectAltNames(true);
        this.evaluator.setCheckSubjectDN(false);
        this.evaluator.setCheckSubjectDNCommonName(false);
        this.evaluator.setSubjectAltNameTypes(Collections.singleton(X509Support.URI_ALT_NAME));
        this.names.add("http://wacky.internet2.edu/idp");
        this.testEvaluateFailure("URL subject alt name was invalid", this.names, this.cred);
    }

    @Test
    public void testAltNamesEnabledNoTypes() {
        this.evaluator.setCheckSubjectAltNames(true);
        this.evaluator.setCheckSubjectDN(false);
        this.evaluator.setCheckSubjectDNCommonName(false);
        this.evaluator.setSubjectAltNameTypes(new HashSet());
        this.names.add(this.altNameDNS);
        this.testEvaluateFailure("Alt names were enabled but no types configured to be extracted", this.names, this.cred);
    }

    @Test
    public void testAllOptionsEnabled() {
        this.names.clear();
        this.names.add(this.subjectCN);
        this.names.add("blah.somewhere.org");
        this.testEvaluateSuccess("Common name was valid", this.names, this.cred);
        this.names.clear();
        this.names.add(this.subjectDN);
        this.names.add("blah.somewhere.org");
        this.names.add("cn=blah.somewhere.org,o=MyOrg");
        this.testEvaluateSuccess("DN was valid", this.names, this.cred);
        this.names.clear();
        this.names.add(this.altNameDNS);
        this.names.add("blah.somewhere.org");
        this.testEvaluateSuccess("DNS alt name was valid", this.names, this.cred);
        this.names.clear();
        this.names.add("blah.somewhere.org");
        this.names.add("cn=blah.somewhere.org,o=MyOrg");
        this.testEvaluateFailure("No trusted names were valid", this.names, this.cred);
    }

    @Test
    public void testNameCheckNotActive() {
        this.evaluator.setCheckSubjectAltNames(false);
        this.evaluator.setCheckSubjectDN(false);
        this.evaluator.setCheckSubjectDNCommonName(false);
        this.names.add(this.subjectCN);
        this.testEvaluateSuccess("Name checking was not active", this.names, this.cred);
    }

    @Test
    public void testNoTrustedNames() {
        this.names.clear();
        this.testEvaluateFailure("Trusted name set was empty", this.names, this.cred);
    }

    @Test
    public void testTrustedNamesNull() {
        this.names.clear();
        this.testEvaluateFailure("Trusted name set was null", null, this.cred);
    }

    @Test(enabled=false)
    private void testEvaluateSuccess(String message, Set<String> trustedNames, X509Credential untrustedCred) {
        try {
            if (!this.evaluator.evaluate(untrustedCred, trustedNames)) {
                Assert.fail((String)("Evaluation of X509Credential failed, success was expected: " + message));
            }
        }
        catch (SecurityException e) {
            Assert.fail((String)("Evaluation failed due to processing exception: " + e.getMessage()));
        }
    }

    @Test(enabled=false)
    private void testEvaluateFailure(String message, Set<String> trustedNames, X509Credential untrustedCred) {
        try {
            if (this.evaluator.evaluate(untrustedCred, trustedNames)) {
                Assert.fail((String)("Evaluation of X509Credential succeeded, failure was expected: " + message));
            }
        }
        catch (SecurityException e) {
            Assert.fail((String)("Evaluation failed due to processing exception: " + e.getMessage()));
        }
    }
}

