/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.impl;

import java.io.InputStream;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.SecurityException;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.PKIXTrustEvaluator;
import org.opensaml.security.x509.PKIXValidationInformation;
import org.opensaml.security.x509.PKIXValidationOptions;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.security.x509.impl.BasicPKIXValidationInformation;
import org.opensaml.security.x509.impl.CertPathPKIXTrustEvaluator;
import org.opensaml.security.x509.impl.CertPathPKIXValidationOptions;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CertPathPKIXTrustEvaluatorTest
extends XMLObjectBaseTestCase {
    private static final String DATA_PATH = "/org/opensaml/security/x509/impl/";
    private static final Set<X509CRL> EMPTY_CRLS = new HashSet<X509CRL>();
    private static final Set<X509Certificate> EMPTY_ANCHORS = new HashSet<X509Certificate>();
    private static final Integer MAX_DEPTH = 10;
    private PKIXTrustEvaluator pkixEvaluator;
    private PKIXValidationInformation info;
    private X509Credential cred;
    private CertPathPKIXValidationOptions opts;
    private static Set<String> testPolicy1 = Collections.singleton("1.3.6.1.4.1.32473.2011.6.20");
    private static Set<String> testPolicy2 = Collections.singleton("1.3.6.1.4.1.32473.2011.6.21");

    @BeforeMethod
    protected void setUp() throws Exception {
        this.pkixEvaluator = new CertPathPKIXTrustEvaluator();
        this.info = null;
        this.cred = null;
        this.opts = null;
    }

    @Test
    public void testGood() {
        this.cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateSuccess("Valid path was specified", this.info, this.cred);
    }

    @Test
    public void testIncompletePath() {
        this.cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateFailure("Incomplete path was specified, missing issuing CA certificate", this.info, this.cred);
    }

    @Test
    public void testNoAnchors() {
        this.cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        this.info = this.getPKIXInfoSet(EMPTY_ANCHORS, EMPTY_CRLS, MAX_DEPTH);
        this.testValidateProcessingError("No trust anchors specified", this.info, this.cred);
    }

    @Test
    public void testNonRootIssuerAsTrustAnchor() {
        this.cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        this.info = this.getPKIXInfoSet(this.getCertificates("inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateSuccess("Incomplete path was specified, missing (non-issuing) CA certificate in path", this.info, this.cred);
    }

    @Test
    public void testRevokedV1() {
        this.cred = this.getCredential("foo-1A1-revoked.crt", new String[0]);
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateSuccess("Sanity check that revoked cert is otherwise good, sans CRLs", this.info, this.cred);
        this.cred = this.getCredential("foo-1A1-revoked.crt", new String[0]);
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), this.getCRLS("inter1A1-v1.crl"), MAX_DEPTH);
        this.testValidateFailure("Specified certificate was revoked, V1 CRL was processed", this.info, this.cred);
    }

    @Test
    public void testRevokedV1CRLinCred() {
        this.cred = this.getCredential("foo-1A1-revoked.crt", new String[0]);
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateSuccess("Sanity check that revoked cert is otherwise good, sans CRLs", this.info, this.cred);
        this.cred = this.getCredential("foo-1A1-revoked.crt", new String[0]);
        ((BasicX509Credential)this.cred).setCRLs(this.getCRLS("inter1A1-v1.crl"));
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateFailure("Specified certificate was revoked, V1 CRL from credential was processed", this.info, this.cred);
    }

    @Test
    public void testRevokedV2() {
        this.cred = this.getCredential("foo-1A1-revoked.crt", new String[0]);
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateSuccess("Sanity check that revoked cert is otherwise good, sans CRLs", this.info, this.cred);
        this.cred = this.getCredential("foo-1A1-revoked.crt", new String[0]);
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), this.getCRLS("inter1A1-v2.crl"), MAX_DEPTH);
        this.testValidateFailure("Specified certificate was revoked, V2 CRL was processed", this.info, this.cred);
    }

    @Test
    public void testRevokedV2CRLinCred() {
        this.cred = this.getCredential("foo-1A1-revoked.crt", new String[0]);
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateSuccess("Sanity check that revoked cert is otherwise good, sans CRLs", this.info, this.cred);
        this.cred = this.getCredential("foo-1A1-revoked.crt", new String[0]);
        ((BasicX509Credential)this.cred).setCRLs(this.getCRLS("inter1A1-v2.crl"));
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateFailure("Specified certificate was revoked, V2 CRL from credential was processed", this.info, this.cred);
    }

    @Test
    public void testEmptyCRL() {
        this.cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        this.info = this.getPKIXInfoSet(this.getCertificates("inter1A1-ca.crt"), this.getCRLS("inter1A1-v1-empty.crl"), MAX_DEPTH);
        this.testValidateSuccess("Certificate was valid, empty V1 CRL was processed", this.info, this.cred);
    }

    @Test
    public void testIncompleteCRLsForChain() {
        this.cred = this.getCredential("foo-1A1-good.crt", "inter1A1-ca.crt", "inter1A-ca.crt");
        ((BasicX509Credential)this.cred).setCRLs(this.getCRLS("inter1A1-v2.crl"));
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateFailure("Certificate was valid (non-revoked), V2 CRL for intermediate CA was processed, missing complete CRL info for chain", this.info, this.cred);
    }

    @Test
    public void testExpiredCRL() {
        this.cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), this.getCRLS("inter1A1-v1-expired.crl"), MAX_DEPTH);
        this.testValidateFailure("Certificate was valid, expired V1 CRL was processed", this.info, this.cred);
    }

    @Test
    public void testNonRevokedCertWithNonEmptyCRL() {
        this.cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), this.getCRLS("inter1A1-v1.crl"), MAX_DEPTH);
        this.testValidateSuccess("Certificate was valid, V1 CRL containing other revolcations was processed", this.info, this.cred);
    }

    @Test
    public void testEntityCertExpired() {
        this.cred = this.getCredential("foo-1A1-expired.crt", new String[0]);
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateFailure("Specified certificate was expired", this.info, this.cred);
    }

    @Test
    public void testGoodPathInCred() {
        this.cred = this.getCredential("foo-1A1-good.crt", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateSuccess("Valid path was specified, intermediate path in credential chain", this.info, this.cred);
        this.cred = this.getCredential("foo-1A1-good.crt", "inter1A1-ca.crt");
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt", "inter1A-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateSuccess("Valid path was specified, intermediate path in credential chain", this.info, this.cred);
    }

    @Test
    public void testGoodPathInCredNoAnchors() {
        this.cred = this.getCredential("foo-1A1-good.crt", "inter1A1-ca.crt", "inter1A-ca.crt", "root1-ca.crt");
        this.info = this.getPKIXInfoSet(this.getCertificates("root2-ca.crt", "inter2A-ca.crt", "inter2B-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateFailure("Complete good path was specified in cred, but no relevant trust anchors", this.info, this.cred);
    }

    @Test
    public void testIncompletePathInCred() {
        this.cred = this.getCredential("foo-1A1-good.crt", "inter1A1-ca.crt");
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH);
        this.testValidateFailure("Incomplete path was specified, neither contains required intermediate cert", this.info, this.cred);
    }

    @Test
    public void testPathTooDeep() {
        this.cred = this.getCredential("foo-1A1-good.crt", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, 2);
        this.testValidateSuccess("Valid path was specified, depth was equal to max path depth", this.info, this.cred);
        this.cred = this.getCredential("foo-1A1-good.crt", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.info = this.getPKIXInfoSet(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, 1);
        this.testValidateFailure("Valid path was specified, but depth exceeded max path depth", this.info, this.cred);
    }

    @Test
    public void testAnyPolicy() {
        this.cred = this.getCredential("mdt-signer.1.crt", "mdt-ica.1.crt");
        this.info = this.getPKIXInfoSet(this.getCertificates("mdt-root.crt"), EMPTY_CRLS, 2);
        this.opts = this.getPKIXOptions(testPolicy1, false, false);
        this.testValidateSuccess("Intermediate CA with anyPolicy (2.5.29.32.0) entry permitted", this.info, this.cred, this.opts);
    }

    @Test
    public void testExplicitPolicy() {
        this.cred = this.getCredential("mdt-signer.1.crt", "mdt-ica.1.crt");
        this.info = this.getPKIXInfoSet(this.getCertificates("mdt-root.crt"), EMPTY_CRLS, 2);
        this.opts = this.getPKIXOptions(testPolicy1, false, true);
        this.testValidateFailure("Intermediate CA with anyPolicy (2.5.29.32.0), but anyPolicy is inhibited", this.info, this.cred, this.opts);
        this.cred = this.getCredential("mdt-signer.2.crt", "mdt-ica.2.crt");
        this.testValidateSuccess("Intermediate CA with explicit policy " + testPolicy1, this.info, this.cred, this.opts);
        this.cred = this.getCredential("mdt-signer.3.crt", "mdt-ica.3.crt");
        this.testValidateSuccess("Intermediate CA with explicit policies " + testPolicy1 + ", " + testPolicy2, this.info, this.cred, this.opts);
    }

    @Test
    public void testExplicitPolicyMap() {
        this.cred = this.getCredential("mdt-signer.3.crt", "mdt-ica.3.crt");
        this.info = this.getPKIXInfoSet(this.getCertificates("mdt-root.crt"), EMPTY_CRLS, 2);
        this.opts = this.getPKIXOptions(testPolicy2, false, true);
        this.testValidateSuccess("Intermediate CA with policy mapping, and mapping is permitted", this.info, this.cred, this.opts);
    }

    @Test
    public void testExplicitPolicyNoMap() {
        this.cred = this.getCredential("mdt-signer.3.crt", "mdt-ica.3.crt");
        this.info = this.getPKIXInfoSet(this.getCertificates("mdt-root.crt"), EMPTY_CRLS, 2);
        this.opts = this.getPKIXOptions(testPolicy2, true, true);
        this.testValidateFailure("Intermediate CA with policy mapping, but mapping is inhibited", this.info, this.cred, this.opts);
    }

    @Test(enabled=false)
    private void testValidateSuccess(String message, PKIXValidationInformation info, X509Credential cred) {
        try {
            if (!this.pkixEvaluator.validate(info, cred)) {
                Assert.fail((String)("Evaluation of X509Credential failed, success was expected: " + message));
            }
        }
        catch (SecurityException e) {
            Assert.fail((String)("Evaluation failed due to processing exception: " + e.getMessage()));
        }
    }

    @Test(enabled=false)
    private void testValidateFailure(String message, PKIXValidationInformation info, X509Credential cred) {
        try {
            if (this.pkixEvaluator.validate(info, cred)) {
                Assert.fail((String)("Evaluation of X509Credential succeeded, failure was expected: " + message));
            }
        }
        catch (SecurityException e) {
            Assert.fail((String)("Evaluation failed due to processing exception: " + e.getMessage()));
        }
    }

    @Test(enabled=false)
    private void testValidateProcessingError(String message, PKIXValidationInformation info, X509Credential cred) {
        try {
            if (this.pkixEvaluator.validate(info, cred)) {
                Assert.fail((String)("Evaluation of X509Credential succeeded, processing failure was expected: " + message));
            } else {
                Assert.fail((String)("Evaluation of X509Credential failed, but processing failure was expected: " + message));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void testValidateSuccess(String message, PKIXValidationInformation info, X509Credential cred, CertPathPKIXValidationOptions opts) {
        try {
            CertPathPKIXTrustEvaluator pkixEvaluator = new CertPathPKIXTrustEvaluator((PKIXValidationOptions)opts);
            if (!pkixEvaluator.validate(info, cred)) {
                Assert.fail((String)("Evaluation of X509Credential failed, success was expected: " + message));
            }
        }
        catch (SecurityException e) {
            Assert.fail((String)("Evaluation failed due to processing exception: " + e.getMessage()));
        }
    }

    private void testValidateFailure(String message, PKIXValidationInformation info, X509Credential cred, CertPathPKIXValidationOptions opts) {
        try {
            CertPathPKIXTrustEvaluator pkixEvaluator = new CertPathPKIXTrustEvaluator((PKIXValidationOptions)opts);
            if (pkixEvaluator.validate(info, cred)) {
                Assert.fail((String)("Evaluation of X509Credential succeeded, failure was expected: " + message));
            }
        }
        catch (SecurityException e) {
            Assert.fail((String)("Evaluation failed due to processing exception: " + e.getMessage()));
        }
    }

    private BasicX509Credential getCredential(String entityCertFileName, String ... chainMembers) {
        X509Certificate entityCert = this.getCertificate(entityCertFileName);
        BasicX509Credential cred = new BasicX509Credential(entityCert);
        HashSet<X509Certificate> certChain = new HashSet<X509Certificate>();
        certChain.add(entityCert);
        for (String member : chainMembers) {
            certChain.add(this.getCertificate(member));
        }
        cred.setEntityCertificateChain(certChain);
        return cred;
    }

    private PKIXValidationInformation getPKIXInfoSet(Collection<X509Certificate> certs, Collection<X509CRL> crls, Integer depth) {
        return new BasicPKIXValidationInformation(certs, crls, depth);
    }

    private CertPathPKIXValidationOptions getPKIXOptions(Set<String> initialPolicies, boolean policyMappingInhibit, boolean anyPolicyInhibit) {
        CertPathPKIXValidationOptions opts = new CertPathPKIXValidationOptions();
        opts.setInitialPolicies(initialPolicies);
        opts.setPolicyMappingInhibit(policyMappingInhibit);
        opts.setAnyPolicyInhibit(anyPolicyInhibit);
        return opts;
    }

    private Collection<X509Certificate> getCertificates(String ... certNames) {
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        for (String certName : certNames) {
            certs.add(this.getCertificate(certName));
        }
        return certs;
    }

    private X509Certificate getCertificate(String fileName) {
        try {
            InputStream ins = this.getInputStream(fileName);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return (X509Certificate)X509Support.decodeCertificates((byte[])encoded).iterator().next();
        }
        catch (Exception e) {
            Assert.fail((String)("Could not create certificate from file: " + fileName + ": " + e.getMessage()));
            return null;
        }
    }

    private Collection<X509CRL> getCRLS(String ... crlNames) {
        HashSet<X509CRL> crls = new HashSet<X509CRL>();
        for (String crlName : crlNames) {
            crls.add(this.getCRL(crlName));
        }
        return crls;
    }

    private X509CRL getCRL(String fileName) {
        try {
            InputStream ins = this.getInputStream(fileName);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return (X509CRL)X509Support.decodeCRLs((byte[])encoded).iterator().next();
        }
        catch (Exception e) {
            Assert.fail((String)("Could not create CRL from file: " + fileName + ": " + e.getMessage()));
            return null;
        }
    }

    private InputStream getInputStream(String fileName) {
        return CertPathPKIXTrustEvaluatorTest.class.getResourceAsStream(DATA_PATH + fileName);
    }
}

