/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.impl;

import java.io.InputStream;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.SecurityException;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.PKIXValidationInformation;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.security.x509.impl.BasicPKIXValidationInformation;
import org.opensaml.security.x509.impl.PKIXX509CredentialTrustEngine;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PKIXX509CredentialTrustEngineTest
extends XMLObjectBaseTestCase {
    private static final String DATA_PATH = "/org/opensaml/security/x509/impl/";
    private static final Set<X509CRL> EMPTY_CRLS = new HashSet<X509CRL>();
    private static final Set<X509Certificate> EMPTY_ANCHORS = new HashSet<X509Certificate>();
    private static final Integer MAX_DEPTH = 10;
    private PKIXX509CredentialTrustEngine engine;
    private X509Credential cred;
    private CriteriaSet criteriaSet;
    private String subjectCN;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.subjectCN = "foo.example.org";
        this.criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion("dummy-entity-id")});
    }

    @Test
    public void testGoodPathInAnchors() {
        this.cred = this.getCredential("foo-1A1-good.crt", new String[0]);
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt", "inter1A-ca.crt", "inter1A1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateSuccess("Entity cert was good, path in trust anchors set");
    }

    @Test
    public void testGoodPathInCred() {
        this.cred = this.getCredential("foo-1A1-good.crt", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateSuccess("Entity cert was good, full path in cred");
    }

    @Test
    public void testGoodPathNoTrustedNames() {
        this.cred = this.getCredential("foo-1A1-good.crt", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, new String[0]);
        this.testValidateFailure("Entity cert was good, full path in cred, no trusted names");
    }

    @Test
    public void testGoodPathBadTrustedName() {
        this.cred = this.getCredential("foo-1A1-good.crt", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, "NOT" + this.subjectCN);
        this.testValidateFailure("Entity cert was good, full path in cred, bad trusted names");
    }

    @Test
    public void testCertRevoked() {
        this.cred = this.getCredential("foo-1A1-revoked.crt", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), this.getCRLS("inter1A1-v1.crl"), MAX_DEPTH, this.subjectCN);
        this.testValidateFailure("Entity cert was revoked");
    }

    @Test
    public void testCertExpired() {
        this.cred = this.getCredential("foo-1A1-expired.crt", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(this.getCertificates("root1-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateFailure("Entity cert was expired");
    }

    @Test
    public void testMissingAnchor() {
        this.cred = this.getCredential("foo-1A1-good.crt", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(this.getCertificates("root2-ca.crt", "inter2A-ca.crt", "inter2B-ca.crt"), EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateFailure("No path to entity cert, root CA trust anchor missing");
    }

    @Test
    public void testNoAnchors() {
        this.cred = this.getCredential("foo-1A1-good.crt", "inter1A-ca.crt", "inter1A1-ca.crt");
        this.engine = this.getEngine(EMPTY_ANCHORS, EMPTY_CRLS, MAX_DEPTH, this.subjectCN);
        this.testValidateFailure("No trust anchors at all in validation set");
    }

    @Test(enabled=false)
    private void testValidateSuccess(String message) {
        try {
            if (!this.engine.validate(this.cred, this.criteriaSet)) {
                Assert.fail((String)("Evaluation of X509Credential failed, success was expected: " + message));
            }
        }
        catch (SecurityException e) {
            Assert.fail((String)("Evaluation failed due to processing exception: " + e.getMessage()));
        }
    }

    @Test(enabled=false)
    private void testValidateFailure(String message) {
        try {
            if (this.engine.validate(this.cred, this.criteriaSet)) {
                Assert.fail((String)("Evaluation of X509Credential succeeded, failure was expected: " + message));
            }
        }
        catch (SecurityException e) {
            Assert.fail((String)("Evaluation failed due to processing exception: " + e.getMessage()));
        }
    }

    private BasicX509Credential getCredential(String entityCertFileName, String ... chainMembers) {
        X509Certificate entityCert = this.getCertificate(entityCertFileName);
        BasicX509Credential cred1 = new BasicX509Credential(entityCert);
        HashSet<X509Certificate> certChain = new HashSet<X509Certificate>();
        certChain.add(entityCert);
        for (String member : chainMembers) {
            certChain.add(this.getCertificate(member));
        }
        cred1.setEntityCertificateChain(certChain);
        return cred1;
    }

    private PKIXX509CredentialTrustEngine getEngine(Collection<X509Certificate> certs, Collection<X509CRL> crls, Integer depth, String ... trustedNames) {
        PKIXValidationInformation info = this.getPKIXInfoSet(certs, crls, depth);
        ArrayList<PKIXValidationInformation> infoList = new ArrayList<PKIXValidationInformation>();
        infoList.add(info);
        HashSet<String> names = new HashSet<String>();
        for (String trustedName : trustedNames) {
            names.add(trustedName);
        }
        StaticPKIXValidationInformationResolver resolver = new StaticPKIXValidationInformationResolver(infoList, names);
        return new PKIXX509CredentialTrustEngine((PKIXValidationInformationResolver)resolver);
    }

    private PKIXValidationInformation getPKIXInfoSet(Collection<X509Certificate> certs, Collection<X509CRL> crls, Integer depth) {
        return new BasicPKIXValidationInformation(certs, crls, depth);
    }

    private Collection<X509Certificate> getCertificates(String ... certNames) {
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        for (String certName : certNames) {
            certs.add(this.getCertificate(certName));
        }
        return certs;
    }

    private X509Certificate getCertificate(String fileName) {
        try {
            InputStream ins = this.getInputStream(fileName);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return (X509Certificate)X509Support.decodeCertificates((byte[])encoded).iterator().next();
        }
        catch (Exception e) {
            Assert.fail((String)("Could not create certificate from file: " + fileName + ": " + e.getMessage()));
            return null;
        }
    }

    private Collection<X509CRL> getCRLS(String ... crlNames) {
        HashSet<X509CRL> crls = new HashSet<X509CRL>();
        for (String crlName : crlNames) {
            crls.add(this.getCRL(crlName));
        }
        return crls;
    }

    private X509CRL getCRL(String fileName) {
        try {
            InputStream ins = this.getInputStream(fileName);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return (X509CRL)X509Support.decodeCRLs((byte[])encoded).iterator().next();
        }
        catch (Exception e) {
            Assert.fail((String)("Could not create CRL from file: " + fileName + ": " + e.getMessage()));
            return null;
        }
    }

    private InputStream getInputStream(String fileName) {
        return PKIXX509CredentialTrustEngineTest.class.getResourceAsStream(DATA_PATH + fileName);
    }
}

