/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.tls.impl;

import java.util.ArrayList;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.trust.impl.ExplicitX509CertificateTrustEngine;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.impl.PKIXX509CredentialTrustEngine;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.opensaml.security.x509.tls.CertificateNameOptions;
import org.opensaml.security.x509.tls.impl.BasicClientTLSValidationConfiguration;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicClientTLSValidationConfigurationTest {
    private BasicClientTLSValidationConfiguration config;

    @BeforeMethod
    public void setUp() {
        this.config = new BasicClientTLSValidationConfiguration();
    }

    @Test
    public void testCredentialTrustEngine() {
        Assert.assertNull((Object)this.config.getX509TrustEngine());
        StaticCredentialResolver credResolver = new StaticCredentialResolver(new ArrayList());
        ExplicitX509CertificateTrustEngine trustEngine = new ExplicitX509CertificateTrustEngine((CredentialResolver)credResolver);
        this.config.setX509TrustEngine((TrustEngine)trustEngine);
        Assert.assertNotNull((Object)this.config.getX509TrustEngine());
    }

    @Test
    public void testX509CredentialTrustEngine() {
        Assert.assertNull((Object)this.config.getX509TrustEngine());
        StaticPKIXValidationInformationResolver pkixResolver = new StaticPKIXValidationInformationResolver(null, null);
        PKIXX509CredentialTrustEngine trustEngine = new PKIXX509CredentialTrustEngine((PKIXValidationInformationResolver)pkixResolver);
        this.config.setX509TrustEngine((TrustEngine)trustEngine);
        Assert.assertNotNull((Object)this.config.getX509TrustEngine());
    }

    @Test
    public void testNameOptions() {
        Assert.assertNull((Object)this.config.getCertificateNameOptions());
        this.config.setCertificateNameOptions(new CertificateNameOptions());
        Assert.assertNotNull((Object)this.config.getCertificateNameOptions());
    }
}

